/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.imagecomparison;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;

public abstract class ComparisonResult {
    private static final String VISUALIZATION = "visualization";
    private final Map<String, Object> commandResult;

    public ComparisonResult(Map<String, Object> commandResult) {
        this.commandResult = commandResult;
    }

    protected void verifyPropertyPresence(String propertyName) {
        if (!this.commandResult.containsKey(propertyName)) {
            throw new IllegalStateException(String.format("There is no '%s' attribute in the resulting command output %s. Did you set the options properly?", propertyName, this.commandResult));
        }
    }

    public byte[] getVisualization() {
        this.verifyPropertyPresence(VISUALIZATION);
        return ((String)this.getCommandResult().get(VISUALIZATION)).getBytes(StandardCharsets.UTF_8);
    }

    public void storeVisualization(File destination) throws IOException {
        byte[] data = Base64.decodeBase64((byte[])this.getVisualization());
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream stream = new FileOutputStream(destination);){
            ((OutputStream)stream).write(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static int toSeleniumCoordinate(Object openCVCoordinate) {
        if (openCVCoordinate instanceof Long) {
            return ((Long)openCVCoordinate).intValue();
        }
        if (openCVCoordinate instanceof Double) {
            return ((Double)openCVCoordinate).intValue();
        }
        return (Integer)openCVCoordinate;
    }

    public static Rectangle mapToRect(Map<String, Object> map) {
        return new Rectangle(ComparisonResult.toSeleniumCoordinate(map.get("x")), ComparisonResult.toSeleniumCoordinate(map.get("y")), ComparisonResult.toSeleniumCoordinate(map.get("height")), ComparisonResult.toSeleniumCoordinate(map.get("width")));
    }

    public static Point mapToPoint(Map<String, Object> map) {
        return new Point(ComparisonResult.toSeleniumCoordinate(map.get("x")), ComparisonResult.toSeleniumCoordinate(map.get("y")));
    }

    protected Map<String, Object> getCommandResult() {
        return this.commandResult;
    }
}

