/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.extensions;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.extensions.DatarefExtension;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DatarefExtensionTest {
    @Test
    public void writeExtension() {
        DatarefExtension datarefExtension = new DatarefExtension();
        datarefExtension.setDataref(URI.create("http://example"));
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId("aaa").withSource(URI.create("http://localhost")).withType("example").withExtension((CloudEventExtension)datarefExtension)).build();
        Assertions.assertThat((Object)event.getExtension("dataref")).isEqualTo((Object)"http://example");
    }

    @Test
    public void parseExtension() {
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId("aaa").withSource(URI.create("http://localhost")).withType("example").withExtension("dataref", "http://example")).build();
        DatarefExtension datarefExtension = (DatarefExtension)ExtensionProvider.getInstance().parseExtension(DatarefExtension.class, (CloudEventExtensions)event);
        Assertions.assertThat((Object)datarefExtension).isNotNull();
        Assertions.assertThat((URI)datarefExtension.getDataref()).isEqualTo((Object)URI.create("http://example"));
    }
}

