/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.core.extensions.DistributedTracingExtension;
import io.cloudevents.core.test.Data;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.net.URI;
import java.util.Objects;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractUriAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class BaseCloudEventBuilderTest {
    @Test
    public void copyAndRemoveExtension() {
        Assertions.assertThat((Iterable)Data.V1_WITH_JSON_DATA_WITH_EXT.getExtensionNames()).contains((Object[])new String[]{"astring"});
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).withoutExtension("astring")).build();
        Assertions.assertThat((Iterable)event.getExtensionNames()).doesNotContain((Object[])new String[]{"astring"});
    }

    @Test
    public void copyAndRemoveMaterializedExtension() {
        DistributedTracingExtension ext = new DistributedTracingExtension();
        ext.setTraceparent("aaa");
        CloudEvent given = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).withExtension((CloudEventExtension)ext)).build();
        Assertions.assertThat((Iterable)given.getExtensionNames()).contains((Object[])new String[]{"traceparent"}).doesNotContain((Object[])new String[]{"tracestate"});
        CloudEvent have = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)given).withoutExtension((CloudEventExtension)ext)).build();
        Assertions.assertThat((Iterable)have.getExtensionNames()).doesNotContain((Object[])new String[]{"traceparent", "tracestate"});
        Assertions.assertThat((Object)Data.V1_WITH_JSON_DATA_WITH_EXT).isEqualTo((Object)have);
    }

    @Test
    public void testLongExtensionNameV1() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).withExtension("thisextensionnameistoolong", "")).build());
    }

    @Test
    public void testLongExtensionNameV03() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).withExtension("thisextensionnameistoolong", "")).build());
    }

    @Test
    public void testInvalidExtensionName() {
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            CloudEvent cloudEvent = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).withExtension("ExtensionName", "")).build();
        });
        String expectedMessage = "Invalid extensions name: ExtensionName";
        String actualMessage = exception.getMessage();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)actualMessage.contains(expectedMessage));
    }

    @Test
    public void testBinaryExtension() {
        String EXT_NAME = "verifyme";
        CloudEvent given = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_MIN).withExtension("verifyme", Data.BINARY_VALUE).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)given);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)given.getExtensionNames().contains("verifyme"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)given.getExtension("verifyme"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Data.BINARY_VALUE, (Object)given.getExtension("verifyme"));
    }

    @Test
    public void withoutDataRemovesDataAttributeFromCopiedCloudEvent() {
        CloudEvent original = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).build();
        CloudEvent copy = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)original).withoutData().build();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThat((Object)copy.getData()).isNull(), () -> Assertions.assertThat((String)copy.getDataContentType()).isEqualTo("application/json"), () -> {
            AbstractUriAssert cfr_ignored_0 = (AbstractUriAssert)Assertions.assertThat((URI)copy.getDataSchema()).isEqualTo((Object)Data.DATASCHEMA);
        }});
    }

    @Test
    public void withoutDataContentTypeRemovesDataContentTypeAttributeFromCopiedCloudEvent() {
        CloudEvent original = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).build();
        CloudEvent copy = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)original).withoutDataContentType().build();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
            AbstractByteArrayAssert cfr_ignored_0 = (AbstractByteArrayAssert)Assertions.assertThat((byte[])Objects.requireNonNull(copy.getData()).toBytes()).isEqualTo((Object)Data.DATA_JSON_SERIALIZED);
        }, () -> Assertions.assertThat((String)copy.getDataContentType()).isNull(), () -> {
            AbstractUriAssert cfr_ignored_0 = (AbstractUriAssert)Assertions.assertThat((URI)copy.getDataSchema()).isEqualTo((Object)Data.DATASCHEMA);
        }});
    }

    @Test
    public void withoutDataSchemaRemovesDataSchemaAttributeFromCopiedCloudEvent() {
        CloudEvent original = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)Data.V1_WITH_JSON_DATA_WITH_EXT).build();
        CloudEvent copy = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)original).withoutDataSchema().build();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
            AbstractByteArrayAssert cfr_ignored_0 = (AbstractByteArrayAssert)Assertions.assertThat((byte[])Objects.requireNonNull(copy.getData()).toBytes()).isEqualTo((Object)Data.DATA_JSON_SERIALIZED);
        }, () -> Assertions.assertThat((String)copy.getDataContentType()).isEqualTo("application/json"), () -> Assertions.assertThat((URI)copy.getDataSchema()).isNull()});
    }
}

