/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.core.mock.CSVFormat;
import io.cloudevents.core.mock.MockBinaryMessageWriter;
import io.cloudevents.core.mock.MockStructuredMessageReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class EventMessageRoundtripTest {
    @ParameterizedTest
    @MethodSource(value={"io.cloudevents.core.test.Data#allEventsWithoutExtensions"})
    void structuredToEvent(CloudEvent input) {
        Assertions.assertThat((Object)GenericStructuredMessageReader.from((CloudEvent)input, (EventFormat)CSVFormat.INSTANCE).toEvent()).isEqualTo((Object)input);
    }

    @ParameterizedTest
    @MethodSource(value={"io.cloudevents.core.test.Data#allEventsWithoutExtensions"})
    void structuredToMockStructuredMessageToEvent(CloudEvent input) {
        Assertions.assertThat((Object)new MockStructuredMessageReader(input, CSVFormat.INSTANCE).toEvent()).isEqualTo((Object)input);
    }

    @ParameterizedTest
    @MethodSource(value={"io.cloudevents.core.test.Data#allEvents"})
    void binaryToMockBinaryMessageToEvent(CloudEvent input) {
        Assertions.assertThat((Object)new MockBinaryMessageWriter(input).toEvent()).isEqualTo((Object)input);
    }
}

