/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.core.mock.CSVFormat;
import io.cloudevents.rw.CloudEventRWException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MessageUtilsTest {
    MessageUtilsTest() {
    }

    @Test
    void parseStructuredOrBinaryMessage_Exception() {
        CloudEventRWException cloudEventRWException = (CloudEventRWException)org.junit.jupiter.api.Assertions.assertThrows(CloudEventRWException.class, () -> MessageUtils.parseStructuredOrBinaryMessage(() -> null, eventFormat -> null, () -> null, specVersion -> null));
        Assertions.assertThat((Comparable)cloudEventRWException.getKind()).isEqualTo((Object)CloudEventRWException.CloudEventRWExceptionKind.UNKNOWN_ENCODING);
    }

    @ParameterizedTest
    @MethodSource
    void testBadContentTypes(String contentType) {
        CloudEventRWException exception = (CloudEventRWException)org.junit.jupiter.api.Assertions.assertThrows(CloudEventRWException.class, () -> MessageUtils.parseStructuredOrBinaryMessage(() -> contentType, eventFormat -> null, () -> "1.0", specVersion -> null));
        Assertions.assertThat((Comparable)exception.getKind()).isEqualTo((Object)CloudEventRWException.CloudEventRWExceptionKind.UNKNOWN_ENCODING);
    }

    @Test
    void testParseStructuredOrBinaryMessage_StructuredMode() {
        MessageUtils.parseStructuredOrBinaryMessage(() -> "application/cloudevents+csv;", eventFormat -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(eventFormat instanceof CSVFormat));
            return null;
        }, () -> null, specVersion -> null);
    }

    @ParameterizedTest
    @MethodSource
    void testParseStructuredOrBinaryMessage_BinaryMode(String specVersionHeader, SpecVersion expectedSpecVersion) {
        MessageUtils.parseStructuredOrBinaryMessage(() -> null, eventFormat -> null, () -> specVersionHeader, specVersion -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedSpecVersion, (Object)specVersion);
            return null;
        });
    }

    private static Stream<Arguments> testParseStructuredOrBinaryMessage_BinaryMode() {
        return Stream.of(Arguments.of((Object[])new Object[]{"0.3", SpecVersion.V03}), Arguments.of((Object[])new Object[]{"1.0", SpecVersion.V1}));
    }

    private static Stream<Arguments> testBadContentTypes() {
        return Stream.of(Arguments.of((Object[])new Object[]{"application/cloudevents"}), Arguments.of((Object[])new Object[]{"application/cloudevents+morse"}));
    }
}

