/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.mock;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.impl.BaseBinaryMessageReader;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

public class MockBinaryMessageWriter
extends BaseBinaryMessageReader
implements MessageReader,
CloudEventContextReader,
CloudEventWriterFactory<MockBinaryMessageWriter, MockBinaryMessageWriter>,
CloudEventWriter<MockBinaryMessageWriter> {
    private SpecVersion version;
    private Map<String, Object> context;
    private CloudEventData data;

    public MockBinaryMessageWriter(SpecVersion version, Map<String, Object> context, CloudEventData data) {
        this.version = version;
        this.context = context;
        this.data = data;
    }

    public MockBinaryMessageWriter(SpecVersion version, Map<String, Object> context, byte[] data) {
        this(version, context, (CloudEventData)BytesCloudEventData.wrap((byte[])data));
    }

    public MockBinaryMessageWriter() {
        this.context = new HashMap<String, Object>();
    }

    public MockBinaryMessageWriter(CloudEvent event) {
        this();
        CloudEventUtils.toReader((CloudEvent)event).read((CloudEventWriterFactory)this);
    }

    public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException, IllegalStateException {
        if (this.version == null) {
            throw new IllegalStateException("MockBinaryMessage is empty");
        }
        CloudEventWriter writer = writerFactory.create(this.version);
        this.readContext((CloudEventContextWriter)writer);
        if (this.data != null) {
            return (V)writer.end(mapper.map(this.data));
        }
        return (V)writer.end();
    }

    public MockBinaryMessageWriter end(CloudEventData value) throws CloudEventRWException {
        this.data = value;
        return this;
    }

    public MockBinaryMessageWriter end() {
        return this;
    }

    public MockBinaryMessageWriter create(SpecVersion version) {
        this.version = version;
        return this;
    }

    public void readContext(CloudEventContextWriter writer) throws CloudEventRWException {
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            if (entry.getValue() instanceof String) {
                writer.withContextAttribute(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof OffsetDateTime) {
                writer.withContextAttribute(entry.getKey(), (OffsetDateTime)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof URI) {
                writer.withContextAttribute(entry.getKey(), (URI)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Number) {
                writer.withContextAttribute(entry.getKey(), (Number)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                writer.withContextAttribute(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            throw new IllegalStateException("Illegal value inside context map: " + entry);
        }
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        this.context.put(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
        this.context.put(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        this.context.put(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
        this.context.put(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
        this.context.put(name, value);
        return this;
    }
}

