/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.test;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.v03.CloudEventBuilder;
import io.cloudevents.types.Time;
import java.math.BigDecimal;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.stream.Stream;

public class Data {
    public static final String ID = "1";
    public static final String TYPE = "mock.test";
    public static final URI SOURCE = URI.create("http://localhost/source");
    public static final String DATACONTENTTYPE_JSON = "application/json";
    public static final String DATACONTENTTYPE_XML = "application/xml";
    public static final String DATACONTENTTYPE_TEXT = "text/plain";
    public static final URI DATASCHEMA = URI.create("http://localhost/schema");
    public static final String SUBJECT = "sub";
    public static final OffsetDateTime TIME = Time.parseTime((String)"2018-04-26T14:48:09+02:00");
    public static byte[] DATA_JSON_SERIALIZED = "{}".getBytes();
    public static byte[] DATA_XML_SERIALIZED = "<stuff></stuff>".getBytes();
    public static byte[] DATA_TEXT_SERIALIZED = "Hello World Lorena!".getBytes();
    public static byte[] BINARY_VALUE = new byte[]{-32, -1, 0, 68, -86};
    public static final CloudEvent V1_MIN = io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).build();
    public static final CloudEvent V1_WITH_JSON_DATA = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withData("application/json", DATASCHEMA, DATA_JSON_SERIALIZED)).withSubject("sub").withTime(TIME).build();
    public static final CloudEvent V1_WITH_JSON_DATA_WITH_FRACTIONAL_TIME = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withData("application/json", DATASCHEMA, DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Time.parseTime((String)"2018-04-26T14:48:09.1234Z")).build();
    public static final CloudEvent V1_WITH_JSON_DATA_WITH_EXT = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withData("application/json", DATASCHEMA, DATA_JSON_SERIALIZED)).withSubject("sub").withTime(TIME).withExtension("astring", "aaa")).withExtension("aboolean", Boolean.valueOf(true))).withExtension("anumber", (Number)10)).build();
    public static final CloudEvent V1_WITH_JSON_DATA_WITH_EXT_STRING = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withData("application/json", DATASCHEMA, DATA_JSON_SERIALIZED)).withSubject("sub").withTime(TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10")).build();
    public static final CloudEvent V1_WITH_XML_DATA = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withData("application/xml", DATA_XML_SERIALIZED)).withSubject("sub").withTime(TIME).build();
    public static final CloudEvent V1_WITH_TEXT_DATA = ((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withData("text/plain", DATA_TEXT_SERIALIZED)).withSubject("sub").withTime(TIME).build();
    public static final CloudEvent V1_WITH_BINARY_EXT = io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withExtension("binary", BINARY_VALUE).build();
    public static final CloudEvent V1_WITH_NUMERIC_EXT = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(SOURCE).withExtension("integer", (Number)42)).withExtension("decimal", (Number)new BigDecimal("42.42"))).withExtension("float", (Number)Float.valueOf(4.2f))).withExtension("long", (Number)new Long(4200L))).build();
    public static final CloudEvent V03_MIN = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)V1_MIN).build();
    public static final CloudEvent V03_WITH_JSON_DATA = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)V1_WITH_JSON_DATA).build();
    public static final CloudEvent V03_WITH_JSON_DATA_WITH_EXT = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)V1_WITH_JSON_DATA_WITH_EXT).build();
    public static final CloudEvent V03_WITH_JSON_DATA_WITH_EXT_STRING = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)V1_WITH_JSON_DATA_WITH_EXT_STRING).build();
    public static final CloudEvent V03_WITH_XML_DATA = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)V1_WITH_XML_DATA).build();
    public static final CloudEvent V03_WITH_TEXT_DATA = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)V1_WITH_TEXT_DATA).build();

    public static Stream<CloudEvent> allEvents() {
        return Stream.concat(Data.v1Events(), Data.v03Events());
    }

    public static Stream<CloudEvent> allEventsWithoutExtensions() {
        return Stream.concat(Data.v1Events(), Data.v03Events()).filter(e -> e.getExtensionNames().isEmpty());
    }

    public static Stream<CloudEvent> allEventsWithStringExtensions() {
        return Stream.concat(Data.v1EventsWithStringExt(), Data.v03EventsWithStringExt());
    }

    public static Stream<CloudEvent> v1Events() {
        return Stream.of(V1_MIN, V1_WITH_JSON_DATA, V1_WITH_JSON_DATA_WITH_EXT, V1_WITH_XML_DATA, V1_WITH_TEXT_DATA);
    }

    public static Stream<CloudEvent> v1NonRoundTripEvents() {
        return Stream.of(V1_WITH_BINARY_EXT);
    }

    public static Stream<CloudEvent> v03Events() {
        return Stream.of(V03_MIN, V03_WITH_JSON_DATA, V03_WITH_JSON_DATA_WITH_EXT, V03_WITH_XML_DATA, V03_WITH_TEXT_DATA);
    }

    public static Stream<CloudEvent> v1EventsWithStringExt() {
        return Data.v1Events().map(ce -> {
            io.cloudevents.core.v1.CloudEventBuilder builder = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)ce);
            ce.getExtensionNames().forEach(k -> {
                io.cloudevents.core.v1.CloudEventBuilder cfr_ignored_0 = (io.cloudevents.core.v1.CloudEventBuilder)builder.withExtension(k, Objects.toString(ce.getExtension(k)));
            });
            return builder.build();
        });
    }

    public static Stream<CloudEvent> v03EventsWithStringExt() {
        return Data.v03Events().map(ce -> {
            CloudEventBuilder builder = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)ce);
            ce.getExtensionNames().forEach(k -> {
                CloudEventBuilder cfr_ignored_0 = (CloudEventBuilder)builder.withExtension(k, Objects.toString(ce.getExtension(k)));
            });
            return builder.build();
        });
    }
}

