/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.test.Data;
import io.cloudevents.core.v03.CloudEventV03;
import io.cloudevents.core.v1.CloudEventBuilder;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CloudEventBuilderTest {
    @ParameterizedTest
    @MethodSource(value={"io.cloudevents.core.test.Data#v1Events"})
    void testCopyWithBuilder(CloudEvent event) {
        Assertions.assertThat((Object)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)event).build()).isEqualTo((Object)event);
    }

    @Test
    void testToV03() {
        CloudEvent input = ((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10")).build();
        CloudEventV03 expected = ((io.cloudevents.core.v03.CloudEventBuilder)((io.cloudevents.core.v03.CloudEventBuilder)((io.cloudevents.core.v03.CloudEventBuilder)((io.cloudevents.core.v03.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10")).build();
        CloudEventV03 actual = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)input).build();
        Assertions.assertThat((Comparable)expected.getSpecVersion()).isEqualTo((Object)SpecVersion.V03);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    void testCopyExtensions() {
        CloudEventBuilder templateBuilder = (CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10");
        CloudEvent event = templateBuilder.build();
        CloudEvent cloned = new CloudEventBuilder(event).build();
        Assertions.assertThat((Object)cloned).isEqualTo((Object)event);
    }

    @Test
    void testNewBuilder() {
        CloudEventBuilder templateBuilder = (CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10");
        CloudEvent event = templateBuilder.build();
        CloudEvent cloned = templateBuilder.newBuilder().build();
        Assertions.assertThat((Object)cloned).isEqualTo((Object)event);
    }

    @Test
    void testMissingId() {
        Assertions.assertThatCode(() -> io.cloudevents.core.builder.CloudEventBuilder.v1().withSource(URI.create("http://localhost")).withType("aaa").build()).hasMessageContaining("Attribute 'id' cannot be null");
    }

    @Test
    void testMissingSource() {
        Assertions.assertThatCode(() -> io.cloudevents.core.builder.CloudEventBuilder.v1().withId("000").withType("aaa").build()).hasMessageContaining("Attribute 'source' cannot be null");
    }

    @Test
    void testMissingType() {
        Assertions.assertThatCode(() -> io.cloudevents.core.builder.CloudEventBuilder.v1().withId("000").withSource(URI.create("http://localhost")).build()).hasMessageContaining("Attribute 'type' cannot be null");
    }
}

