/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class KubernetesClientBuilder {
    private Config config;
    private HttpClient.Factory factory;
    private Class<KubernetesClient> clazz;
    private ExecutorSupplier executorSupplier;

    public KubernetesClientBuilder() {
        String className = "io.fabric8.kubernetes.client.DefaultKubernetesClient";
        try {
            this.clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            try {
                this.clazz = KubernetesClient.class.getClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                throw KubernetesClientException.launderThrowable(ex);
            }
        }
    }

    public KubernetesClient build() {
        if (this.config == null) {
            this.config = new ConfigBuilder().build();
        }
        try {
            if (this.factory == null) {
                return this.clazz.getConstructor(Config.class).newInstance(this.config);
            }
            HttpClient client = this.factory.createHttpClient(this.config);
            return this.clazz.getConstructor(HttpClient.class, Config.class, ExecutorSupplier.class).newInstance(client, this.config, this.executorSupplier);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public KubernetesClientBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public KubernetesClientBuilder withConfig(String config) {
        this.config = (Config)Serialization.unmarshal(config);
        return this;
    }

    public KubernetesClientBuilder withConfig(InputStream config) {
        this.config = (Config)Serialization.unmarshal(config);
        return this;
    }

    public KubernetesClientBuilder withHttpClientFactory(HttpClient.Factory factory) {
        this.factory = factory;
        return this;
    }

    public KubernetesClientBuilder withTaskExecutor(Executor executor) {
        this.executorSupplier = () -> executor;
        return this;
    }

    public KubernetesClientBuilder withTaskExecutorSupplier(ExecutorSupplier executorSupplier) {
        this.executorSupplier = executorSupplier;
        return this;
    }

    @FunctionalInterface
    public static interface ExecutorSupplier
    extends Supplier<Executor> {
        default public void onClose(Executor executor) {
        }
    }
}

