package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CertificateSigningRequestStatusFluent<A extends CertificateSigningRequestStatusFluent<A>> extends Fluent<A> {


    public String getCertificate();
    public A withCertificate(String certificate);
    public Boolean hasCertificate();
    public A withNewCertificate(StringBuilder arg1);
    public A withNewCertificate(int[] arg1,int arg2,int arg3);
    public A withNewCertificate(char[] arg1);
    public A withNewCertificate(StringBuffer arg1);
    public A withNewCertificate(byte[] arg1,int arg2);
    public A withNewCertificate(byte[] arg1);
    public A withNewCertificate(char[] arg1,int arg2,int arg3);
    public A withNewCertificate(byte[] arg1,int arg2,int arg3);
    public A withNewCertificate(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCertificate(String arg1);
    public A addToConditions(int index,CertificateSigningRequestCondition item);
    public A setToConditions(int index,CertificateSigningRequestCondition item);
    public A addToConditions(CertificateSigningRequestCondition... items);
    public A addAllToConditions(Collection<CertificateSigningRequestCondition> items);
    public A removeFromConditions(CertificateSigningRequestCondition... items);
    public A removeAllFromConditions(Collection<CertificateSigningRequestCondition> items);
    public A removeMatchingFromConditions(Predicate<CertificateSigningRequestConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<CertificateSigningRequestCondition> getConditions();
    public List<CertificateSigningRequestCondition> buildConditions();
    public CertificateSigningRequestCondition buildCondition(int index);
    public CertificateSigningRequestCondition buildFirstCondition();
    public CertificateSigningRequestCondition buildLastCondition();
    public CertificateSigningRequestCondition buildMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate);
    public A withConditions(List<CertificateSigningRequestCondition> conditions);
    public A withConditions(CertificateSigningRequestCondition... conditions);
    public Boolean hasConditions();
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewCondition();
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewConditionLike(CertificateSigningRequestCondition item);
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> setNewConditionLike(int index,CertificateSigningRequestCondition item);
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editCondition(int index);
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editFirstCondition();
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editLastCondition();
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertificateSigningRequestConditionFluent<CertificateSigningRequestStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


}
