package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ReplicaSetListFluent<A extends ReplicaSetListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,ReplicaSet item);
    public A setToItems(int index,ReplicaSet item);
    public A addToItems(ReplicaSet... items);
    public A addAllToItems(Collection<ReplicaSet> items);
    public A removeFromItems(ReplicaSet... items);
    public A removeAllFromItems(Collection<ReplicaSet> items);
    public A removeMatchingFromItems(Predicate<ReplicaSetBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ReplicaSet> getItems();
    public List<ReplicaSet> buildItems();
    public ReplicaSet buildItem(int index);
    public ReplicaSet buildFirstItem();
    public ReplicaSet buildLastItem();
    public ReplicaSet buildMatchingItem(Predicate<ReplicaSetBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ReplicaSetBuilder> predicate);
    public A withItems(List<ReplicaSet> items);
    public A withItems(ReplicaSet... items);
    public Boolean hasItems();
    public ReplicaSetListFluent.ItemsNested<A> addNewItem();
    public ReplicaSetListFluent.ItemsNested<A> addNewItemLike(ReplicaSet item);
    public ReplicaSetListFluent.ItemsNested<A> setNewItemLike(int index,ReplicaSet item);
    public ReplicaSetListFluent.ItemsNested<A> editItem(int index);
    public ReplicaSetListFluent.ItemsNested<A> editFirstItem();
    public ReplicaSetListFluent.ItemsNested<A> editLastItem();
    public ReplicaSetListFluent.ItemsNested<A> editMatchingItem(Predicate<ReplicaSetBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetFluent<ReplicaSetListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
