package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressTLSBuilder extends IngressTLSFluentImpl<IngressTLSBuilder> implements VisitableBuilder<IngressTLS,IngressTLSBuilder> {

    IngressTLSFluent<?> fluent;
    Boolean validationEnabled;

    public IngressTLSBuilder() {
        this(true);
    }

    public IngressTLSBuilder(Boolean validationEnabled) {
        this(new IngressTLS(), validationEnabled);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressTLS(), validationEnabled);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent,IngressTLS instance) {
        this(fluent, instance, true);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent,IngressTLS instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHosts(instance.getHosts()); 
        fluent.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressTLSBuilder(IngressTLS instance) {
        this(instance,true);
    }

    public IngressTLSBuilder(IngressTLS instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHosts(instance.getHosts()); 
        this.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressTLS build() {
        IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressTLSBuilder that = (IngressTLSBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
