package com.theokanning.openai.fine_tuning;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author LiangTao
 * @date 2024年05月14 10:12
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Wandb {

    /**
     * The name of the project that the new run will be created under.
     */
    private String project;


    /**
     * A display name to set for the run. If not set, we will use the Job ID as the name.
     */
    private String name;

    /**
     * run_id
     */
    @JsonProperty("run_id")
    private String runId;

    /**
     * The entity to use for the run. This allows you to set the team or username of the WandB user that you would like associated with the run.  <br>
     * If not set, the default entity for the registered WandB API key is used.
     */
    private String entity;

    /**
     * A list of tags to be attached to the newly created run. <br>
     * These tags are passed through directly to WandB. Some default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
     */
    private List<String> tags;
}
