/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service;

import com.theokanning.openai.Usage;
import com.theokanning.openai.completion.chat.AssistantMessage;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatToolCall;

public class ChatMessageAccumulator {
    private final AssistantMessage messageChunk;
    private final AssistantMessage accumulatedMessage;
    private final Usage usage;

    public ChatMessageAccumulator(AssistantMessage messageChunk, AssistantMessage accumulatedMessage, Usage usage) {
        this.messageChunk = messageChunk;
        this.accumulatedMessage = accumulatedMessage;
        this.usage = usage;
    }

    public boolean isFunctionCall() {
        AssistantMessage asstMsg = this.getAccumulatedMessage();
        return asstMsg.getFunctionCall() != null && asstMsg.getFunctionCall().getName() != null || asstMsg.getToolCalls() != null && !asstMsg.getToolCalls().isEmpty();
    }

    public boolean isChatMessage() {
        return !this.isFunctionCall();
    }

    public AssistantMessage getMessageChunk() {
        return this.messageChunk;
    }

    public AssistantMessage getAccumulatedMessage() {
        return this.accumulatedMessage;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public ChatFunctionCall getChatFunctionCallChunk() {
        AssistantMessage msC = this.getMessageChunk();
        ChatFunctionCall functionCall = msC.getFunctionCall();
        if (functionCall == null) {
            functionCall = ((ChatToolCall)msC.getToolCalls().get(0)).getFunction();
        }
        return functionCall;
    }

    public ChatFunctionCall getAccumulatedChatFunctionCall() {
        return this.getAccumulatedMessage().getFunctionCall();
    }
}

