/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service.assistant_stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.assistants.StreamEvent;
import com.theokanning.openai.service.OpenAiService;
import com.theokanning.openai.service.SSEFormatException;
import com.theokanning.openai.service.assistant_stream.AssistantSSE;
import io.reactivex.FlowableEmitter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public class AssistantResponseBodyCallback
implements Callback<ResponseBody> {
    private static final ObjectMapper mapper = OpenAiService.defaultObjectMapper();
    private FlowableEmitter<AssistantSSE> emitter;

    public AssistantResponseBodyCallback(FlowableEmitter<AssistantSSE> emitter) {
        this.emitter = emitter;
    }

    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        try {
            if (!response.isSuccessful()) {
                HttpException e = new HttpException(response);
                ResponseBody errorBody = response.errorBody();
                try {
                    if (errorBody == null) {
                        throw e;
                    }
                    OpenAiError error = (OpenAiError)mapper.readValue(errorBody.string(), OpenAiError.class);
                    throw new OpenAiHttpException(error, (Exception)((Object)e), e.code());
                }
                catch (Throwable error) {
                    if (errorBody != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable) {
                            error.addSuppressed(throwable);
                        }
                    }
                    throw error;
                }
            }
            try (InputStream in = ((ResponseBody)response.body()).byteStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String line;
                AssistantSSE sse = null;
                while (!this.emitter.isCancelled() && (line = reader.readLine()) != null) {
                    if (line.startsWith("event:")) {
                        String event = line.substring(6).trim();
                        line = reader.readLine();
                        if (line.startsWith("data:")) {
                            String data = line.substring(5).trim();
                            sse = new AssistantSSE(StreamEvent.valueByName((String)event), data);
                            continue;
                        }
                        throw new SSEFormatException("Invalid sse format! " + line);
                    }
                    if (line.isEmpty() && sse != null) {
                        this.emitter.onNext(sse);
                        if (sse.isDone()) {
                            sse = null;
                            break;
                        }
                        sse = null;
                        continue;
                    }
                    throw new SSEFormatException("Invalid sse format! " + line);
                }
                if (sse != null) {
                    this.emitter.onNext(sse);
                }
                this.emitter.onComplete();
            }
        }
        catch (Throwable t) {
            this.onFailure(call, t);
        }
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        this.emitter.onError(t);
    }
}

