/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service.assistant_stream;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.theokanning.openai.assistants.message.content.DeltaContent;
import com.theokanning.openai.assistants.message.content.MessageDelta;
import com.theokanning.openai.assistants.message.content.Text;
import com.theokanning.openai.assistants.run.ToolCall;
import com.theokanning.openai.assistants.run.ToolCallCodeInterpreter;
import com.theokanning.openai.assistants.run.ToolCallFunction;
import com.theokanning.openai.assistants.run_step.RunStepDelta;
import com.theokanning.openai.assistants.run_step.StepDetails;
import com.theokanning.openai.utils.JsonUtil;
import java.util.List;
import java.util.Optional;

public class DeltaUtil {
    private static final ObjectMapper mapper = JsonUtil.getInstance();

    public static MessageDelta accumulatMessageDelta(MessageDelta accumulated, MessageDelta nowDelta) {
        if (accumulated == null) {
            return (MessageDelta)mapper.readValue(mapper.writeValueAsString((Object)nowDelta), MessageDelta.class);
        }
        MessageDelta result = (MessageDelta)mapper.readValue(mapper.writeValueAsString((Object)accumulated), MessageDelta.class);
        DeltaContent nowDeltaContent = (DeltaContent)nowDelta.getDelta().getContent().get(0);
        List preContent = result.getDelta().getContent();
        Optional<DeltaContent> existsCurrent = preContent.stream().filter(c -> c.getIndex().equals(nowDeltaContent.getIndex())).findFirst();
        if (existsCurrent.isPresent()) {
            DeltaContent existsContent = existsCurrent.get();
            if (nowDeltaContent.getType().equals("text")) {
                Text text = existsContent.getText();
                text.setValue(text.getValue() + nowDeltaContent.getText().getValue());
                if (nowDeltaContent.getText().getAnnotations() != null && !nowDeltaContent.getText().getAnnotations().isEmpty()) {
                    if (text.getAnnotations() == null) {
                        text.setAnnotations(nowDeltaContent.getText().getAnnotations());
                    } else {
                        text.getAnnotations().addAll(nowDeltaContent.getText().getAnnotations());
                    }
                }
            }
            if (nowDeltaContent.getType().equals("image_file") && nowDeltaContent.getImageFile() != null) {
                existsContent.setImageFile(nowDeltaContent.getImageFile());
            }
            if (nowDeltaContent.getType().equals("image_url") && nowDeltaContent.getImageUrl() != null) {
                existsContent.setImageUrl(nowDeltaContent.getImageUrl());
            }
        } else {
            result.getDelta().getContent().add(nowDeltaContent);
        }
        return result;
    }

    public static RunStepDelta accumulatRunStepDelta(RunStepDelta accumulatedRsd, RunStepDelta nowRSD) {
        if (accumulatedRsd == null) {
            return (RunStepDelta)mapper.readValue(mapper.writeValueAsString((Object)nowRSD), RunStepDelta.class);
        }
        RunStepDelta result = (RunStepDelta)mapper.readValue(mapper.writeValueAsString((Object)accumulatedRsd), RunStepDelta.class);
        StepDetails currentDetails = nowRSD.getDelta().getStepDetails();
        ToolCall currentToolCallPart = (ToolCall)currentDetails.getToolCalls().get(0);
        StepDetails preDetails = result.getDelta().getStepDetails();
        Optional<ToolCall> existsToolCallOptional = preDetails.getToolCalls().stream().filter(t -> t.getIndex().equals(currentToolCallPart.getIndex())).findFirst();
        if (!existsToolCallOptional.isPresent()) {
            preDetails.setToolCalls(currentDetails.getToolCalls());
            return result;
        }
        ToolCall existsToolCallPart = existsToolCallOptional.get();
        if (existsToolCallPart.getType().equals("function")) {
            ToolCallFunction currentFunPart = currentToolCallPart.getFunction();
            ToolCallFunction existsFunPart = existsToolCallPart.getFunction();
            if (currentFunPart.getName() != null && !currentFunPart.getName().isEmpty()) {
                existsFunPart.setName(Optional.ofNullable(existsFunPart.getName()).orElse("") + currentFunPart.getName());
            }
            if (currentFunPart.getArguments() != null) {
                existsFunPart.setArguments((JsonNode)new TextNode(Optional.ofNullable(existsFunPart.getArguments()).orElse((JsonNode)new TextNode("")).asText() + currentFunPart.getArguments().asText()));
            }
        } else if (!existsToolCallPart.getType().equals("file_search") && existsToolCallPart.getType().equals("code_interpreter")) {
            ToolCallCodeInterpreter currentCodeInterpreter = currentToolCallPart.getCodeInterpreter();
            ToolCallCodeInterpreter existsCodeInterpreter = existsToolCallPart.getCodeInterpreter();
            if (currentCodeInterpreter.getInput() != null) {
                existsCodeInterpreter.setInput(existsCodeInterpreter.getInput() + currentCodeInterpreter.getInput());
            }
            if (currentCodeInterpreter.getOutputs() != null) {
                if (existsCodeInterpreter.getOutputs() == null) {
                    existsCodeInterpreter.setOutputs(currentCodeInterpreter.getOutputs());
                } else {
                    existsCodeInterpreter.getOutputs().addAll(currentCodeInterpreter.getOutputs());
                }
            }
        }
        return result;
    }
}

