/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.StreamBufferingEncoder;

interface ListeningEncoder {
    public void setListener(Http2OutboundFrameListener var1);

    public static final class ListeningDefaultHttp2ConnectionEncoder
    extends DefaultHttp2ConnectionEncoder
    implements ListeningEncoder {
        private Http2OutboundFrameListener listener = new Http2OutboundFrameListener();

        public ListeningDefaultHttp2ConnectionEncoder(Http2Connection connection, Http2FrameWriter frameWriter) {
            super(connection, frameWriter);
        }

        @Override
        public void setListener(Http2OutboundFrameListener listener) {
            this.listener = (Http2OutboundFrameListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        }

        public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
            this.listener.onPing(ack, data);
            return super.writePing(ctx, ack, data, promise);
        }

        public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
            this.listener.onWindowUpdate(streamId, windowSizeIncrement);
            return super.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
        }

        public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean eos, ChannelPromise promise) {
            this.listener.onData(streamId, data, padding, eos);
            return super.writeData(ctx, streamId, data, padding, eos, promise);
        }
    }

    public static final class ListeningStreamBufferingEncoder
    extends StreamBufferingEncoder
    implements ListeningEncoder {
        private Http2OutboundFrameListener listener = new Http2OutboundFrameListener();

        public ListeningStreamBufferingEncoder(Http2ConnectionEncoder encoder) {
            super(encoder);
        }

        @Override
        public void setListener(Http2OutboundFrameListener listener) {
            this.listener = (Http2OutboundFrameListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        }

        public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
            this.listener.onPing(ack, data);
            return super.writePing(ctx, ack, data, promise);
        }

        public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
            this.listener.onWindowUpdate(streamId, windowSizeIncrement);
            return super.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
        }

        public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean eos, ChannelPromise promise) {
            this.listener.onData(streamId, data, padding, eos);
            return super.writeData(ctx, streamId, data, padding, eos, promise);
        }
    }

    public static class Http2OutboundFrameListener {
        public void onWindowUpdate(int streamId, int windowSizeIncrement) {
        }

        public void onPing(boolean ack, long data) {
        }

        public void onData(int streamId, ByteBuf data, int padding, boolean endStream) {
        }
    }
}

