/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

final class MonoToCompletableFuture<T>
extends CompletableFuture<T>
implements CoreSubscriber<T> {
    final AtomicReference<Subscription> ref = new AtomicReference();

    MonoToCompletableFuture() {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription s;
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled && (s = (Subscription)this.ref.getAndSet(null)) != null) {
            s.cancel();
        }
        return cancelled;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.ref.getAndSet(s), s)) {
            s.request(Long.MAX_VALUE);
        } else {
            s.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        Subscription s = this.ref.getAndSet(null);
        if (s != null) {
            this.complete(t);
            s.cancel();
        } else {
            Operators.onNextDropped(t, this.currentContext());
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.ref.getAndSet(null) != null) {
            this.completeExceptionally(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.ref.getAndSet(null) != null) {
            this.complete(null);
        }
    }
}

