/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.ConnectionURLParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleURLParser
implements ConnectionURLParser {
    public static final String DB_TYPE = "oracle";
    public static final String PREFIX = "jdbc:oracle:thin:";
    public static final int DEFAULT_PORT = 1521;
    private static Pattern EASY_CONNECT_PATTERN = Pattern.compile("(?<username>.*)@(//)?(?<host>[^:/]+)(?<port>:[0-9]+)?(?<service>[:/][^:/]+)?(?<server>:[^:/]+)?(?<instance>/[^:/]+)?");

    @Override
    public ConnectionInfo parse(String url) {
        if (url != null && url.startsWith(PREFIX)) {
            OracleConnectionInfo connectionInfo = this.parseTnsName(url.substring(PREFIX.length()));
            if (connectionInfo == null) {
                connectionInfo = OracleURLParser.parseEasyConnect(url.substring(PREFIX.length()));
            }
            if (connectionInfo != null) {
                return new ConnectionInfo.Builder(connectionInfo.getDbPeer()).dbType(DB_TYPE).dbInstance(connectionInfo.getDbInstance()).build();
            }
        }
        return null;
    }

    private OracleConnectionInfo parseTnsName(String url) {
        String hosts = OracleURLParser.parseDatabaseHostsFromTnsUrl(url);
        if (hosts != null) {
            int idxServiceName = url.indexOf("SERVICE_NAME");
            int start = url.indexOf(61, idxServiceName) + 1;
            int end = url.indexOf(")", start);
            String serviceName = url.substring(start, end);
            return new OracleConnectionInfo().setDbPeer(hosts).setDbInstance(serviceName);
        }
        return null;
    }

    public static String parseDatabaseHostsFromTnsUrl(String url) {
        int hostStartIndex;
        int beginIndex = url.indexOf("DESCRIPTION");
        if (beginIndex == -1) {
            return null;
        }
        ArrayList<String> hosts = new ArrayList<String>();
        while ((hostStartIndex = url.indexOf("HOST", beginIndex)) != -1) {
            int equalStartIndex = url.indexOf("=", hostStartIndex);
            int hostEndIndex = url.indexOf(")", hostStartIndex);
            String host = url.substring(equalStartIndex + 1, hostEndIndex);
            int port = 1521;
            int portStartIndex = url.indexOf("PORT", hostEndIndex);
            int portEndIndex = url.length();
            if (portStartIndex != -1) {
                int portEqualStartIndex = url.indexOf("=", portStartIndex);
                portEndIndex = url.indexOf(")", portEqualStartIndex);
                port = Integer.parseInt(url.substring(portEqualStartIndex + 1, portEndIndex).trim());
            }
            hosts.add(host.trim() + ":" + port);
            beginIndex = portEndIndex;
        }
        return OracleURLParser.join(",", hosts);
    }

    private static String join(String delimiter, List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                builder.append(list.get(i));
                continue;
            }
            builder.append(list.get(i)).append(delimiter);
        }
        return builder.toString();
    }

    public static OracleConnectionInfo parseEasyConnect(String url) {
        Matcher matcher = EASY_CONNECT_PATTERN.matcher(url);
        if (matcher.matches()) {
            OracleConnectionInfo result = new OracleConnectionInfo();
            String host = matcher.group("host");
            String portGroup = matcher.group("port");
            int dbPort = portGroup != null ? Integer.parseInt(portGroup.substring(1)) : 1521;
            result.setDbPeer(host + ":" + dbPort);
            String service = matcher.group("service");
            if (service != null) {
                result.setDbInstance(service.substring(1));
            } else {
                result.setDbInstance(host);
            }
            return result;
        }
        return null;
    }

    public static class OracleConnectionInfo {
        private String dbInstance;
        private String dbPeer;

        public String getDbInstance() {
            return this.dbInstance;
        }

        public OracleConnectionInfo setDbInstance(String dbInstance) {
            this.dbInstance = dbInstance;
            return this;
        }

        public String getDbPeer() {
            return this.dbPeer;
        }

        public OracleConnectionInfo setDbPeer(String dbPeer) {
            this.dbPeer = dbPeer;
            return this;
        }
    }
}

