/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FrameReassembler;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReassemblyDuplexConnection
implements DuplexConnection {
    private final DuplexConnection delegate;
    private final FrameReassembler frameReassembler;

    public ReassemblyDuplexConnection(DuplexConnection delegate) {
        Objects.requireNonNull(delegate, "delegate must not be null");
        this.delegate = delegate;
        this.frameReassembler = new FrameReassembler(delegate.alloc());
        delegate.onClose().doFinally(s -> this.frameReassembler.dispose()).subscribe();
    }

    @Override
    public Mono<Void> send(Publisher<ByteBuf> frames) {
        return this.delegate.send(frames);
    }

    @Override
    public Mono<Void> sendOne(ByteBuf frame) {
        return this.delegate.sendOne(frame);
    }

    @Override
    public Flux<ByteBuf> receive() {
        return this.delegate.receive().handle(this.frameReassembler::reassembleFrame);
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    @Override
    public Mono<Void> onClose() {
        return this.delegate.onClose();
    }

    public void dispose() {
        this.delegate.dispose();
    }
}

