/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.sqlserver;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseInsertExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.struct.ColumnMeta;
import io.seata.sqlparser.struct.Defaultable;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.Sequenceable;
import io.seata.sqlparser.struct.SqlDefaultExpr;
import io.seata.sqlparser.struct.SqlMethodExpr;
import io.seata.sqlparser.struct.SqlSequenceExpr;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="sqlserver", scope=Scope.PROTOTYPE)
public class SqlServerInsertExecutor
extends BaseInsertExecutor
implements Sequenceable,
Defaultable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerInsertExecutor.class);

    public SqlServerInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        Map<String, List<Object>> pkValuesMap;
        boolean isContainsPk = this.containsPK();
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        if (pkColumnNameList.size() == 1) {
            if (isContainsPk) {
                pkValuesMap = this.getPkValuesByColumn();
            } else if (this.containsColumns()) {
                String columnName = this.getTableMeta().getPrimaryKeyOnlyName().get(0);
                pkValuesMap = Collections.singletonMap(columnName, this.getGeneratedKeys());
            } else {
                pkValuesMap = this.getPkValuesWithNoColumn();
            }
        } else {
            throw new NotSupportYetException("composite primary key is not supported in sqlserver");
        }
        return pkValuesMap;
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        HashSet<String> keySet = new HashSet<String>(pkValuesMap.keySet());
        for (String pkKey : keySet) {
            List<Object> pkValues = pkValuesMap.get(pkKey);
            if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlSequenceExpr) {
                pkValuesMap.put(pkKey, this.getPkValuesBySequence((SqlSequenceExpr)pkValues.get(0)));
                continue;
            }
            if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlDefaultExpr) {
                pkValuesMap.put(pkKey, this.getPkValuesByDefault());
                continue;
            }
            if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlMethodExpr) {
                pkValuesMap.put(pkKey, this.getGeneratedKeys());
                continue;
            }
            if (pkValues.isEmpty() || !(pkValues.get(0) instanceof Null)) continue;
            throw new NotSupportYetException("ms_sqlserver not support null");
        }
        return pkValuesMap;
    }

    @Override
    public String getSequenceSql(SqlSequenceExpr expr) {
        return "SELECT current_value FROM sys.sequences WHERE name = " + expr.getSequence();
    }

    @Override
    public List<Object> getPkValuesByDefault() {
        throw new NotSupportYetException("Default value is not yet supported");
    }

    @Override
    public List<Object> getPkValuesByDefault(String pkKey) throws SQLException {
        throw new NotSupportYetException("Default value with multi pkKey is not yet supported");
    }

    @Override
    public List<Object> getGeneratedKeys() throws SQLException {
        ResultSet genKeys = this.statementProxy.getGeneratedKeys();
        ArrayList<Object> pkValues = new ArrayList<Object>();
        while (genKeys.next()) {
            Object v = genKeys.getObject(1);
            pkValues.add(v);
        }
        if (pkValues.isEmpty()) {
            throw new NotSupportYetException(String.format("not support sql [%s]", this.sqlRecognizer.getOriginalSQL()));
        }
        try {
            genKeys.beforeFirst();
        }
        catch (SQLException e) {
            LOGGER.warn("Fail to reset ResultSet cursor. can not get primary key value");
        }
        int updateCount = this.statementProxy.getUpdateCount();
        if (updateCount > 1 && pkValues.size() == 1) {
            Map<String, ColumnMeta> primaryKeyMap = this.getTableMeta().getPrimaryKeyMap();
            ColumnMeta pkMeta = primaryKeyMap.values().iterator().next();
            if (!pkMeta.isAutoincrement()) {
                throw new SQLException("The primary key value is not isAutoincrement, which should not happen");
            }
            int increment = 0;
            String querySql = "SELECT IDENT_INCR('" + this.getTableMeta().getTableName() + "') As INCR";
            Connection conn = this.statementProxy.getConnection();
            try (Statement ps = conn.createStatement();
                 ResultSet incr = ps.executeQuery(querySql);){
                if (incr.next()) {
                    increment = incr.getInt("INCR");
                }
            }
            if (increment < 1) {
                throw new SQLException("the increment for " + this.getTableMeta().getTableName() + " is illegal");
            }
            long lastPkValue = pkValues.get(0) instanceof BigDecimal ? ((BigDecimal)pkValues.get(0)).longValue() : ((Long)pkValues.get(0)).longValue();
            long beginAt = lastPkValue - (long)(updateCount - 1) * (long)increment;
            pkValues = new ArrayList();
            for (int i = 0; i < updateCount; ++i) {
                pkValues.add(beginAt);
                beginAt += (long)increment;
            }
        }
        return pkValues;
    }

    private Map<String, List<Object>> getPkValuesWithNoColumn() throws SQLException {
        SQLInsertRecognizer recognizer = (SQLInsertRecognizer)this.sqlRecognizer;
        List<String> insertParamsValue = recognizer.getInsertParamsValue();
        boolean insertWithNoPkValue = insertParamsValue.isEmpty();
        if (!insertWithNoPkValue) {
            String paramsValue = insertParamsValue.get(0);
            String[] split = paramsValue.split(",");
            boolean bl = insertWithNoPkValue = this.getTableMeta().getAllColumns().size() > split.length;
        }
        if (insertWithNoPkValue) {
            String columnName = this.getTableMeta().getPrimaryKeyOnlyName().get(0);
            return Collections.singletonMap(columnName, this.getGeneratedKeys());
        }
        return this.getPkValuesByColumn();
    }
}

