/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.utils;

import io.seata.common.util.StringUtils;
import io.seata.saga.statelang.domain.ChoiceState;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.TaskState;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StateMachineUtils {
    public static Set<String> getAllPossibleSubsequentStates(State state) {
        HashSet<String> subsequentStates = new HashSet<String>();
        subsequentStates.add(state.getNext());
        switch (state.getType()) {
            case "ScriptTask": 
            case "ServiceTask": 
            case "SubStateMachine": 
            case "CompensateSubMachine": {
                Optional.ofNullable(((TaskState)state).getCatches()).ifPresent(c -> c.forEach(e -> subsequentStates.add(e.getNext())));
                break;
            }
            case "Choice": {
                Optional.ofNullable(((ChoiceState)state).getChoices()).ifPresent(c -> c.forEach(e -> subsequentStates.add(e.getNext())));
                subsequentStates.add(((ChoiceState)state).getDefault());
                break;
            }
        }
        return subsequentStates.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }
}

