/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid.sqlserver;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import io.seata.common.exception.NotSupportYetException;
import io.seata.sqlparser.ParametersHolder;
import io.seata.sqlparser.druid.BaseRecognizer;
import io.seata.sqlparser.struct.Null;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class BaseSqlServerRecognizer
extends BaseRecognizer {
    public BaseSqlServerRecognizer(String originalSql) {
        super(originalSql);
    }

    public SQLServerOutputVisitor createOutputVisitor(final ParametersHolder parametersHolder, final ArrayList<List<Object>> paramAppenderList, StringBuilder sb) {
        return new SQLServerOutputVisitor(sb){

            public boolean visit(SQLVariantRefExpr x) {
                if ("?".equals(x.getName())) {
                    ArrayList<Object> oneParamValues = parametersHolder.getParameters().get(x.getIndex() + 1);
                    if (paramAppenderList.isEmpty()) {
                        oneParamValues.forEach(param -> paramAppenderList.add(new ArrayList()));
                    }
                    for (int i = 0; i < oneParamValues.size(); ++i) {
                        Object o = oneParamValues.get(i);
                        ((List)paramAppenderList.get(i)).add(o instanceof Null ? null : o);
                    }
                }
                return super.visit(x);
            }
        };
    }

    public String getWhereCondition(SQLExpr where, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    public String getWhereCondition(SQLExpr where) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)new SQLServerOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    public void dealTop(SQLStatement ast) {
        throw new NotSupportYetException("Top expr is not supported");
    }

    public String getDbType() {
        return "sqlserver";
    }

    @Override
    public boolean isSqlSyntaxSupports() {
        SQLServerASTVisitorAdapter visitor = new SQLServerASTVisitorAdapter(){

            public boolean visit(SQLInSubQueryExpr x) {
                throw new NotSupportYetException("not support the sql syntax with InSubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLSubqueryTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with SubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLReplaceStatement x) {
                throw new NotSupportYetException("not support the sql syntax with ReplaceStatement:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLMergeStatement x) {
                throw new NotSupportYetException("not support the sql syntax with MergeStatement:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLInsertStatement x) {
                if (null != x.getQuery()) {
                    throw new NotSupportYetException("not support the sql syntax insert with query:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
                }
                return true;
            }
        };
        this.getAst().accept((SQLASTVisitor)visitor);
        return true;
    }
}

