/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid.sqlserver;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import io.seata.common.util.CollectionUtils;
import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.druid.sqlserver.BaseSqlServerRecognizer;
import io.seata.sqlparser.struct.NotPlaceholderExpr;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.SqlDefaultExpr;
import io.seata.sqlparser.struct.SqlMethodExpr;
import io.seata.sqlparser.struct.SqlSequenceExpr;
import io.seata.sqlparser.util.ColumnUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlServerInsertRecognizer
extends BaseSqlServerRecognizer
implements SQLInsertRecognizer {
    private final SQLServerInsertStatement ast;

    public SqlServerInsertRecognizer(String originalSql, SQLStatement ast) {
        super(originalSql);
        this.ast = (SQLServerInsertStatement)ast;
    }

    @Override
    public boolean insertColumnsIsEmpty() {
        return CollectionUtils.isEmpty(this.ast.getColumns());
    }

    @Override
    public List<String> getInsertColumns() {
        List columnSQLExprs = this.ast.getColumns();
        if (columnSQLExprs.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(columnSQLExprs.size());
        for (SQLExpr expr : columnSQLExprs) {
            if (expr instanceof SQLIdentifierExpr) {
                list.add(((SQLIdentifierExpr)expr).getName());
                continue;
            }
            this.wrapSQLParsingException(expr);
        }
        return list;
    }

    @Override
    public List<List<Object>> getInsertRows(Collection<Integer> primaryKeyIndex) {
        if (this.ast.getTop() != null) {
            this.dealTop((SQLStatement)this.ast);
        }
        List valuesClauses = this.ast.getValuesList();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(valuesClauses.size());
        for (SQLInsertStatement.ValuesClause valuesClause : valuesClauses) {
            List exprList = valuesClause.getValues();
            ArrayList<Object> row = new ArrayList<Object>(exprList.size());
            rows.add(row);
            int len = exprList.size();
            for (int i = 0; i < len; ++i) {
                SQLExpr expr = (SQLExpr)exprList.get(i);
                if (expr instanceof SQLNullExpr) {
                    row.add(Null.get());
                    continue;
                }
                if (expr instanceof SQLValuableExpr) {
                    row.add(((SQLValuableExpr)expr).getValue());
                    continue;
                }
                if (expr instanceof SQLVariantRefExpr) {
                    row.add(((SQLVariantRefExpr)expr).getName());
                    continue;
                }
                if (expr instanceof SQLMethodInvokeExpr) {
                    row.add(SqlMethodExpr.get());
                    continue;
                }
                if (expr instanceof SQLDefaultExpr) {
                    row.add(SqlDefaultExpr.get());
                    continue;
                }
                if (expr instanceof SQLSequenceExpr) {
                    SQLSequenceExpr sequenceExpr = (SQLSequenceExpr)expr;
                    String sequence = sequenceExpr.getSequence().getSimpleName();
                    String function = sequenceExpr.getFunction().name;
                    row.add(new SqlSequenceExpr(sequence, function));
                    continue;
                }
                if (primaryKeyIndex.contains(i)) {
                    this.wrapSQLParsingException(expr);
                }
                row.add(NotPlaceholderExpr.get());
            }
        }
        return rows;
    }

    @Override
    public List<String> getInsertParamsValue() {
        List valuesList = this.ast.getValuesList();
        ArrayList<String> list = new ArrayList<String>();
        for (SQLInsertStatement.ValuesClause m : valuesList) {
            String values = m.toString().replace("VALUES", "").trim();
            if (values.length() > 1) {
                values = values.substring(1, values.length() - 1);
            }
            list.add(values);
        }
        return list;
    }

    @Override
    public List<String> getDuplicateKeyUpdate() {
        return null;
    }

    @Override
    public List<String> getInsertColumnsUnEscape() {
        List<String> insertColumns = this.getInsertColumns();
        return ColumnUtils.delEscape(insertColumns, this.getDbType());
    }

    @Override
    public SQLType getSQLType() {
        return SQLType.INSERT;
    }

    @Override
    public String getTableAlias() {
        return this.ast.getAlias();
    }

    @Override
    public String getTableName() {
        StringBuilder sb = new StringBuilder();
        SQLServerOutputVisitor visitor = new SQLServerOutputVisitor(sb){

            public boolean visit(SQLExprTableSource x) {
                this.printTableSourceExpr(x.getExpr());
                return false;
            }
        };
        visitor.visit(this.ast.getTableSource());
        return sb.toString();
    }

    @Override
    protected SQLStatement getAst() {
        return this.ast;
    }
}

