/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.common.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class VersionedCache {
    protected static final AtomicInteger VERSION = new AtomicInteger();
    protected int cacheVersion;
    protected String name;
    protected Object data;
    protected IsEmpty isEmpty = this::isCommonEmpty;

    private boolean isCommonEmpty() {
        return this.data == null;
    }

    private boolean isMapEmpty() {
        return ((Map)this.data).isEmpty();
    }

    private boolean isCollectionEmpty() {
        return ((Collection)this.data).isEmpty();
    }

    private boolean isArrayEmpty() {
        return ((Object[])this.data).length == 0;
    }

    public int cacheVersion() {
        return this.cacheVersion;
    }

    public <T extends VersionedCache> T autoCacheVersion() {
        this.cacheVersion = VERSION.incrementAndGet();
        return (T)this;
    }

    public <T extends VersionedCache> T cacheVersion(int cacheVersion) {
        this.cacheVersion = cacheVersion;
        return (T)this;
    }

    public String name() {
        return this.name;
    }

    public <T extends VersionedCache> T name(String name) {
        this.name = name;
        return (T)this;
    }

    public <T extends VersionedCache> T subName(VersionedCache parent, String subName) {
        Objects.requireNonNull(parent.name);
        Objects.requireNonNull(subName);
        this.name = parent.name + "/" + subName;
        return (T)this;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public <K, V> Map<K, V> mapData() {
        return (Map)this.data;
    }

    public <T> Collection<T> collectionData() {
        return (Collection)this.data;
    }

    public <T> T[] arrayData() {
        return (Object[])this.data;
    }

    public <T extends VersionedCache> T data(Object data) {
        this.data = data;
        this.isEmpty = data == null ? this::isCommonEmpty : (Map.class.isInstance(data) ? this::isMapEmpty : (Collection.class.isInstance(data) ? this::isCollectionEmpty : (data.getClass().isArray() ? this::isArrayEmpty : this::isCommonEmpty)));
        return (T)this;
    }

    public boolean isExpired(VersionedCache newCache) {
        return newCache.cacheVersion - this.cacheVersion > 0;
    }

    public boolean isEmpty() {
        return this.isEmpty.isEmpty();
    }

    static interface IsEmpty {
        public boolean isEmpty();
    }
}

