/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal;

import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.OrchestrationFacade;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestrationShardingDataSource
extends ShardingDataSource {
    private static final Logger log = LoggerFactory.getLogger(OrchestrationShardingDataSource.class);
    private final OrchestrationFacade orchestrationFacade;
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRuleConfiguration shardingRuleConfig;
    private final Map<String, Object> configMap;
    private final Properties props;

    public OrchestrationShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props, OrchestrationConfiguration config) throws SQLException {
        super(shardingRuleConfig.build(dataSourceMap), configMap, props);
        this.orchestrationFacade = new OrchestrationFacade(config);
        this.dataSourceMap = dataSourceMap;
        this.shardingRuleConfig = shardingRuleConfig;
        this.configMap = configMap;
        this.props = props;
    }

    public void init() throws SQLException {
        this.orchestrationFacade.init(this.dataSourceMap, this.shardingRuleConfig, this.configMap, this.props, this);
    }

    public void close() {
        super.close();
        this.orchestrationFacade.close();
    }
}

