/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.config;

import com.google.common.base.Strings;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingjdbc.orchestration.internal.json.DataSourceJsonConverter;
import io.shardingjdbc.orchestration.internal.json.GsonFactory;
import io.shardingjdbc.orchestration.internal.json.ShardingRuleConfigurationConverter;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class ConfigurationService {
    private final ConfigurationNode configNode;
    private final RegistryCenter regCenter;

    public ConfigurationService(String name, RegistryCenter regCenter) {
        this.configNode = new ConfigurationNode(name);
        this.regCenter = regCenter;
    }

    public void persistShardingConfiguration(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props, boolean isOverwrite) {
        this.persistDataSourceConfiguration(dataSourceMap, isOverwrite);
        this.persistShardingRuleConfiguration(shardingRuleConfig, isOverwrite);
        this.persistShardingConfigMap(configMap, isOverwrite);
        this.persistShardingProperties(props, isOverwrite);
    }

    public boolean hasDataSourceConfiguration() {
        return this.regCenter.isExisted(this.configNode.getFullPath("config/datasource"));
    }

    public boolean hasShardingRuleConfiguration() {
        return this.regCenter.isExisted(this.configNode.getFullPath("config/sharding/rule"));
    }

    public boolean hasShardingConfigMap() {
        return this.regCenter.isExisted(this.configNode.getFullPath("config/sharding/configmap"));
    }

    public boolean hasShardingProperties() {
        return this.regCenter.isExisted(this.configNode.getFullPath("config/sharding/props"));
    }

    private void persistDataSourceConfiguration(Map<String, DataSource> dataSourceMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasDataSourceConfiguration()) {
            this.regCenter.persist(this.configNode.getFullPath("config/datasource"), DataSourceJsonConverter.toJson(dataSourceMap));
        }
    }

    private void persistShardingRuleConfiguration(ShardingRuleConfiguration shardingRuleConfig, boolean isOverwrite) {
        if (isOverwrite || !this.hasShardingRuleConfiguration()) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/rule"), ShardingRuleConfigurationConverter.toJson(shardingRuleConfig));
        }
    }

    private void persistShardingConfigMap(Map<String, Object> configMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasShardingConfigMap()) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/configmap"), GsonFactory.getGson().toJson(configMap));
        }
    }

    private void persistShardingProperties(Properties props, boolean isOverwrite) {
        if (isOverwrite || !this.hasShardingProperties()) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/props"), GsonFactory.getGson().toJson((Object)props));
        }
    }

    public void persistMasterSlaveConfiguration(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap, boolean isOverwrite) {
        this.persistDataSourceConfiguration(dataSourceMap, isOverwrite);
        this.persistMasterSlaveRuleConfiguration(masterSlaveRuleConfig, isOverwrite);
        this.persistMasterSlaveConfigMap(configMap, isOverwrite);
    }

    public boolean hasMasterSlaveRuleConfiguration() {
        return this.regCenter.isExisted(this.configNode.getFullPath("config/masterslave/rule"));
    }

    public boolean hasMasterSlaveConfigMap() {
        return this.regCenter.isExisted(this.configNode.getFullPath("config/masterslave/configmap"));
    }

    private void persistMasterSlaveRuleConfiguration(MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isOverwrite) {
        if (isOverwrite || !this.hasMasterSlaveRuleConfiguration()) {
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/rule"), GsonFactory.getGson().toJson((Object)masterSlaveRuleConfig));
        }
    }

    private void persistMasterSlaveConfigMap(Map<String, Object> configMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasMasterSlaveConfigMap()) {
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/configmap"), GsonFactory.getGson().toJson(configMap));
        }
    }

    public Map<String, DataSource> loadDataSourceMap() {
        return DataSourceJsonConverter.fromJson(this.regCenter.getDirectly(this.configNode.getFullPath("config/datasource")));
    }

    public ShardingRuleConfiguration loadShardingRuleConfiguration() {
        return ShardingRuleConfigurationConverter.fromJson(this.regCenter.getDirectly(this.configNode.getFullPath("config/sharding/rule")));
    }

    public Map<String, Object> loadShardingConfigMap() {
        return (Map)GsonFactory.getGson().fromJson(this.regCenter.getDirectly(this.configNode.getFullPath("config/sharding/configmap")), Map.class);
    }

    public Properties loadShardingProperties() {
        String data = this.regCenter.getDirectly(this.configNode.getFullPath("config/sharding/props"));
        return Strings.isNullOrEmpty((String)data) ? new Properties() : (Properties)GsonFactory.getGson().fromJson(data, Properties.class);
    }

    public MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration() {
        return (MasterSlaveRuleConfiguration)GsonFactory.getGson().fromJson(this.regCenter.getDirectly(this.configNode.getFullPath("config/masterslave/rule")), MasterSlaveRuleConfiguration.class);
    }

    public Map<String, Object> loadMasterSlaveConfigMap() {
        return (Map)GsonFactory.getGson().fromJson(this.regCenter.getDirectly(this.configNode.getFullPath("config/masterslave/configmap")), Map.class);
    }
}

