/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.shardingjdbc.core.api.config.strategy.ComplexShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.HintShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.InlineShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.NoneShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.StandardShardingStrategyConfiguration;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import java.io.IOException;

public final class ShardingStrategyConfigurationGsonTypeAdapter
extends TypeAdapter<ShardingStrategyConfiguration> {
    public ShardingStrategyConfiguration read(JsonReader in) throws IOException {
        String type = "";
        String shardingColumn = "";
        String shardingColumns = "";
        String algorithmClassName = "";
        String preciseAlgorithmClassName = "";
        String rangeAlgorithmClassName = "";
        String algorithmExpression = "";
        in.beginObject();
        block18: while (in.hasNext()) {
            String jsonName;
            switch (jsonName = in.nextName()) {
                case "type": {
                    type = in.nextString();
                    continue block18;
                }
                case "shardingColumn": {
                    shardingColumn = in.nextString();
                    continue block18;
                }
                case "shardingColumns": {
                    shardingColumns = in.nextString();
                    continue block18;
                }
                case "algorithmClassName": {
                    algorithmClassName = in.nextString();
                    continue block18;
                }
                case "preciseAlgorithmClassName": {
                    preciseAlgorithmClassName = in.nextString();
                    continue block18;
                }
                case "rangeAlgorithmClassName": {
                    rangeAlgorithmClassName = in.nextString();
                    continue block18;
                }
                case "algorithmExpression": {
                    algorithmExpression = in.nextString();
                    continue block18;
                }
            }
            throw new ShardingJdbcException("Cannot convert json for property: %s", new Object[]{jsonName});
        }
        in.endObject();
        return this.createStrategy(type, shardingColumn, shardingColumns, algorithmClassName, preciseAlgorithmClassName, rangeAlgorithmClassName, algorithmExpression);
    }

    private ShardingStrategyConfiguration createStrategy(String type, String shardingColumn, String shardingColumns, String algorithmClassName, String preciseAlgorithmClassName, String rangeAlgorithmClassName, String algorithmInlineExpression) {
        if (type.equals(ShardingStrategyType.STANDARD.name())) {
            return new StandardShardingStrategyConfiguration(shardingColumn, preciseAlgorithmClassName, rangeAlgorithmClassName);
        }
        if (type.equals(ShardingStrategyType.COMPLEX.name())) {
            return new ComplexShardingStrategyConfiguration(shardingColumns, algorithmClassName);
        }
        if (type.equals(ShardingStrategyType.INLINE.name())) {
            return new InlineShardingStrategyConfiguration(shardingColumn, algorithmInlineExpression);
        }
        if (type.equals(ShardingStrategyType.HINT.name())) {
            return new HintShardingStrategyConfiguration(algorithmClassName);
        }
        if (type.equals(ShardingStrategyType.NONE.name())) {
            return new NoneShardingStrategyConfiguration();
        }
        return null;
    }

    public void write(JsonWriter out, ShardingStrategyConfiguration value) throws IOException {
        out.beginObject();
        if (value instanceof StandardShardingStrategyConfiguration) {
            out.name("type").value(ShardingStrategyType.STANDARD.name());
            StandardShardingStrategyConfiguration shardingStrategyConfig = (StandardShardingStrategyConfiguration)value;
            out.name("shardingColumn").value(shardingStrategyConfig.getShardingColumn());
            out.name("preciseAlgorithmClassName").value(shardingStrategyConfig.getPreciseAlgorithmClassName());
            out.name("rangeAlgorithmClassName").value(shardingStrategyConfig.getRangeAlgorithmClassName());
        } else if (value instanceof ComplexShardingStrategyConfiguration) {
            out.name("type").value(ShardingStrategyType.COMPLEX.name());
            ComplexShardingStrategyConfiguration shardingStrategyConfig = (ComplexShardingStrategyConfiguration)value;
            out.name("shardingColumns").value(shardingStrategyConfig.getShardingColumns());
            out.name("algorithmClassName").value(shardingStrategyConfig.getAlgorithmClassName());
        } else if (value instanceof InlineShardingStrategyConfiguration) {
            out.name("type").value(ShardingStrategyType.INLINE.name());
            InlineShardingStrategyConfiguration shardingStrategyConfig = (InlineShardingStrategyConfiguration)value;
            out.name("shardingColumn").value(shardingStrategyConfig.getShardingColumn());
            out.name("algorithmExpression").value(shardingStrategyConfig.getAlgorithmExpression());
        } else if (value instanceof HintShardingStrategyConfiguration) {
            out.name("type").value(ShardingStrategyType.HINT.name());
            HintShardingStrategyConfiguration shardingStrategyConfig = (HintShardingStrategyConfiguration)value;
            out.name("algorithmClassName").value(shardingStrategyConfig.getAlgorithmClassName());
        } else if (value instanceof NoneShardingStrategyConfiguration) {
            out.name("type").value(ShardingStrategyType.NONE.name());
        }
        out.endObject();
    }

    private static enum ShardingStrategyType {
        STANDARD,
        COMPLEX,
        INLINE,
        HINT,
        NONE;

    }
}

