/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.reg.etcd.internal.keepalive;

import etcdserverpb.LeaseGrpc;
import etcdserverpb.Rpc;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeepAlive
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KeepAlive.class);
    private static final long DELAY_MILLISECONDS = 100L;
    private final LeaseGrpc.LeaseStub leaseStub;
    private final long heartbeatIntervalMilliseconds;
    private final ConcurrentMap<Long, KeepAliveTask> keepAliveTasks;
    private final ScheduledFuture scheduledFuture;
    private final ScheduledExecutorService scheduledService;

    public KeepAlive(Channel channel, long timeToLiveSeconds) {
        this.leaseStub = LeaseGrpc.newStub(channel);
        this.heartbeatIntervalMilliseconds = timeToLiveSeconds * 1000L / 3L;
        this.keepAliveTasks = new ConcurrentHashMap<Long, KeepAliveTask>();
        this.scheduledService = Executors.newScheduledThreadPool(1);
        this.scheduledFuture = this.scheduledService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (KeepAliveTask keepAliveTask : KeepAlive.this.keepAliveTasks.values()) {
                    keepAliveTask.heartbeat();
                }
            }
        }, 100L, this.heartbeatIntervalMilliseconds, TimeUnit.MILLISECONDS);
    }

    public void heartbeat(long leaseId) {
        this.keepAliveTasks.putIfAbsent(leaseId, new KeepAliveTask(leaseId, this.leaseStub.leaseKeepAlive(this.createResponseObserver(leaseId)), System.currentTimeMillis()));
    }

    private StreamObserver<Rpc.LeaseKeepAliveResponse> createResponseObserver(final long leaseId) {
        return new StreamObserver<Rpc.LeaseKeepAliveResponse>(){

            public void onNext(Rpc.LeaseKeepAliveResponse response) {
                long leaseId2 = response.getID();
                long nextHeartbeatTimestamp = System.currentTimeMillis() + response.getTTL() * 1000L / 3L;
                log.debug("Reschedule heartbeat time for lease {} to {}", (Object)leaseId2, (Object)nextHeartbeatTimestamp);
                KeepAliveTask keepAliveTask = (KeepAliveTask)KeepAlive.this.keepAliveTasks.get(leaseId2);
                if (null != keepAliveTask) {
                    keepAliveTask.setNextHeartbeatTimestamp(nextHeartbeatTimestamp);
                }
            }

            public void onCompleted() {
                log.debug("Keep alive finished");
            }

            public void onError(Throwable cause) {
                log.warn("Keep alive failed, due to {}, renew it", (Object)Status.fromThrowable((Throwable)cause));
                KeepAlive.this.heartbeat(leaseId);
            }
        };
    }

    @Override
    public void close() {
        for (KeepAliveTask keepAliveTask : this.keepAliveTasks.values()) {
            keepAliveTask.close();
        }
        this.keepAliveTasks.clear();
        this.scheduledService.shutdown();
        this.scheduledFuture.cancel(false);
    }

    private class KeepAliveTask
    implements AutoCloseable {
        private final long leaseId;
        private final StreamObserver<Rpc.LeaseKeepAliveRequest> observer;
        private long nextHeartbeatTimestamp;

        public void heartbeat() {
            if (this.nextHeartbeatTimestamp <= System.currentTimeMillis()) {
                log.debug("Heartbeat lease {} at time {}", (Object)this.leaseId, (Object)this.nextHeartbeatTimestamp);
                this.observer.onNext((Object)Rpc.LeaseKeepAliveRequest.newBuilder().setID(this.leaseId).build());
            }
        }

        @Override
        public void close() {
            this.observer.onCompleted();
        }

        @ConstructorProperties(value={"leaseId", "observer", "nextHeartbeatTimestamp"})
        public KeepAliveTask(long leaseId, StreamObserver<Rpc.LeaseKeepAliveRequest> observer, long nextHeartbeatTimestamp) {
            this.leaseId = leaseId;
            this.observer = observer;
            this.nextHeartbeatTimestamp = nextHeartbeatTimestamp;
        }

        public void setNextHeartbeatTimestamp(long nextHeartbeatTimestamp) {
            this.nextHeartbeatTimestamp = nextHeartbeatTimestamp;
        }
    }
}

