/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.reg.etcd.internal.watcher;

import etcdserverpb.Rpc;
import io.grpc.stub.StreamObserver;
import io.shardingjdbc.orchestration.reg.exception.RegException;
import io.shardingjdbc.orchestration.reg.listener.DataChangedEvent;
import io.shardingjdbc.orchestration.reg.listener.EventListener;
import java.beans.ConstructorProperties;
import mvccpb.Kv;

public final class EtcdWatchStreamObserver
implements StreamObserver<Rpc.WatchResponse> {
    private final EventListener eventListener;

    public void onNext(Rpc.WatchResponse response) {
        if (response.getCanceled() || response.getCreated()) {
            return;
        }
        for (Kv.Event event : response.getEventsList()) {
            this.eventListener.onChange(new DataChangedEvent(this.getEventType(event), event.getKv().getKey().toStringUtf8(), event.getKv().getValue().toStringUtf8()));
        }
    }

    private DataChangedEvent.Type getEventType(Kv.Event event) {
        switch (event.getType()) {
            case PUT: {
                return DataChangedEvent.Type.UPDATED;
            }
            case DELETE: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    public void onError(Throwable throwable) {
        throw new RegException(new Exception(throwable));
    }

    public void onCompleted() {
    }

    @ConstructorProperties(value={"eventListener"})
    public EtcdWatchStreamObserver(EventListener eventListener) {
        this.eventListener = eventListener;
    }
}

