/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.yaml;

import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.reg.etcd.EtcdConfiguration;
import io.shardingjdbc.orchestration.reg.zookeeper.ZookeeperConfiguration;

public class YamlOrchestrationConfiguration {
    private String name;
    private EtcdConfiguration etcd;
    private ZookeeperConfiguration zookeeper;
    private boolean overwrite;

    public OrchestrationConfiguration getOrchestrationConfiguration() {
        if (null != this.etcd && null != this.zookeeper) {
            throw new RuntimeException("Can't config both zookeeper and etcd as registry center!");
        }
        return new OrchestrationConfiguration(this.getName(), null != this.etcd ? this.etcd : this.zookeeper, this.overwrite);
    }

    public String getName() {
        return this.name;
    }

    public EtcdConfiguration getEtcd() {
        return this.etcd;
    }

    public ZookeeperConfiguration getZookeeper() {
        return this.zookeeper;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEtcd(EtcdConfiguration etcd) {
        this.etcd = etcd;
    }

    public void setZookeeper(ZookeeperConfiguration zookeeper) {
        this.zookeeper = zookeeper;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

