/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.resources;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.Incremental;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.resources.filtering.ResourcesProcessor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractProcessResourcesMojo
extends TakariLifecycleMojo {
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.properties}")
    private Properties properties;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${session.executionProperties}")
    private Properties sessionProperties;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${settings.localRepository}")
    private File localRepository;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${session.request.userSettingsFile}")
    private File userSettingsFile;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Component
    private ResourcesProcessor processor;
    @Component
    private BuildContext context;

    protected void process(List<Resource> resources, File outputDirectory) throws MojoExecutionException {
        for (Resource resource : resources) {
            boolean filter = Boolean.parseBoolean(resource.getFiltering());
            try {
                File sourceDirectory = new File(resource.getDirectory());
                if (!sourceDirectory.exists()) continue;
                sourceDirectory = sourceDirectory.getCanonicalFile();
                File targetDirectory = resource.getTargetPath() != null ? new File(outputDirectory, resource.getTargetPath()) : outputDirectory;
                if (filter) {
                    HashMap<Object, Object> properties = new HashMap<Object, Object>(this.properties);
                    properties.putAll(this.sessionProperties);
                    properties.put("project", this.project);
                    properties.put("localRepository", this.localRepository);
                    properties.put("userSettingsFile", this.userSettingsFile);
                    this.processor.process(sourceDirectory, targetDirectory, resource.getIncludes(), resource.getExcludes(), properties, this.encoding);
                    continue;
                }
                this.processor.process(sourceDirectory, targetDirectory, resource.getIncludes(), resource.getExcludes(), this.encoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    @Override
    protected void skipMojo() throws MojoExecutionException {
        this.context.markSkipExecution();
    }
}

