/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jdbc;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.jdbc.JDBCClient;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.auth.AuthProvider;

/**
 * Factory interface for creating {@link io.vertx.reactivex.ext.auth.AuthProvider} instances that use the Vert.x JDBC client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.jdbc.JDBCAuth.class)
public class JDBCAuth extends AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCAuth that = (JDBCAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<JDBCAuth> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new JDBCAuth((io.vertx.ext.auth.jdbc.JDBCAuth) obj),
    JDBCAuth::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCAuth delegate;
  
  public JDBCAuth(io.vertx.ext.auth.jdbc.JDBCAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.jdbc.JDBCAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC auth provider implementation
   * @param vertx 
   * @param client the JDBC client instance
   * @return the auth provider
   */
  public static JDBCAuth create(Vertx vertx, JDBCClient client) { 
    JDBCAuth ret = JDBCAuth.newInstance(io.vertx.ext.auth.jdbc.JDBCAuth.create(vertx.getDelegate(), client.getDelegate()));
    return ret;
  }

  /**
   * Set the authentication query to use. Use this if you want to override the default authentication query.
   * @param authenticationQuery the authentication query
   * @return a reference to this for fluency
   */
  public JDBCAuth setAuthenticationQuery(String authenticationQuery) { 
    delegate.setAuthenticationQuery(authenticationQuery);
    return this;
  }

  /**
   * Set the roles query to use. Use this if you want to override the default roles query.
   * @param rolesQuery the roles query
   * @return a reference to this for fluency
   */
  public JDBCAuth setRolesQuery(String rolesQuery) { 
    delegate.setRolesQuery(rolesQuery);
    return this;
  }

  /**
   * Set the permissions query to use. Use this if you want to override the default permissions query.
   * @param permissionsQuery the permissions query
   * @return a reference to this for fluency
   */
  public JDBCAuth setPermissionsQuery(String permissionsQuery) { 
    delegate.setPermissionsQuery(permissionsQuery);
    return this;
  }

  /**
   * Set the role prefix to distinguish from permissions when checking for isPermitted requests.
   * @param rolePrefix a Prefix e.g.: "role:"
   * @return a reference to this for fluency
   */
  public JDBCAuth setRolePrefix(String rolePrefix) { 
    delegate.setRolePrefix(rolePrefix);
    return this;
  }

  /**
   * Compute the hashed password given the unhashed password and the salt without nonce
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @param password the unhashed password
   * @param salt the salt
   * @return the hashed password
   */
  public String computeHash(String password, String salt) { 
    String ret = delegate.computeHash(password, salt);
    return ret;
  }

  /**
   * Compute the hashed password given the unhashed password and the salt
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @param password the unhashed password
   * @param salt the salt
   * @param version the nonce version to use
   * @return the hashed password
   */
  public String computeHash(String password, String salt, int version) { 
    String ret = delegate.computeHash(password, salt, version);
    return ret;
  }

  /**
   * Compute a salt string.
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @return a non null salt value
   */
  public String generateSalt() { 
    String ret = delegate.generateSalt();
    return ret;
  }

  /**
   * Provide a application configuration level on hash nonce's as a ordered list of
   * nonces where each position corresponds to a version.
   *
   * The nonces are supposed not to be stored in the underlying jdbc storage but to
   * be provided as a application configuration. The idea is to add one extra variable
   * to the hash function in order to make breaking the passwords using rainbow tables
   * or precomputed hashes harder. Leaving the attacker only with the brute force
   * approach.
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @param nonces a List of non null Strings.
   * @return a reference to this for fluency
   */
  public JDBCAuth setNonces(JsonArray nonces) { 
    delegate.setNonces(nonces);
    return this;
  }


  public static  JDBCAuth newInstance(io.vertx.ext.auth.jdbc.JDBCAuth arg) {
    return arg != null ? new JDBCAuth(arg) : null;
  }
}
