/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class ServerWebSocketImpl
extends WebSocketImplBase<ServerWebSocket>
implements ServerWebSocket {
    private final String uri;
    private final String path;
    private final String query;
    private final Runnable connectRunnable;
    private final MultiMap headers;
    private boolean connected;
    private boolean rejected;

    public ServerWebSocketImpl(VertxInternal vertx, String uri, String path, String query, MultiMap headers, ConnectionBase conn, boolean supportsContinuation, Runnable connectRunnable, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        super(vertx, conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize);
        this.uri = uri;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.connectRunnable = connectRunnable;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reject() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            if (this.connectRunnable == null) {
                throw new IllegalStateException("Cannot reject websocket on the client side");
            }
            if (this.connected) {
                throw new IllegalStateException("Cannot reject websocket, it has already been written to");
            }
            this.rejected = true;
        }
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            if (this.connectRunnable != null) {
                if (this.rejected) {
                    throw new IllegalStateException("Cannot close websocket, it has been rejected");
                }
                if (!this.connected && !this.closed) {
                    this.connect();
                }
            }
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerWebSocket writeFrame(WebSocketFrame frame) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            if (this.connectRunnable != null) {
                if (this.rejected) {
                    throw new IllegalStateException("Cannot write to websocket, it has been rejected");
                }
                if (!this.connected && !this.closed) {
                    this.connect();
                }
            }
            return (ServerWebSocket)super.writeFrame(frame);
        }
    }

    private void connect() {
        this.connectRunnable.run();
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectNow() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            if (!this.connected && !this.rejected) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRejected() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            return this.rejected;
        }
    }
}

