/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.Listener;
import io.vertx.core.impl.future.SucceededFuture;
import java.util.function.Function;

public final class FailedFuture<T>
extends FutureBase<T> {
    private final Throwable cause;

    public FailedFuture(Throwable t) {
        this(null, t);
    }

    public FailedFuture(ContextInternal context, Throwable t) {
        super(context);
        this.cause = t != null ? t : new NoStackTraceThrowable(null);
    }

    public FailedFuture(String failureMessage) {
        this(null, failureMessage);
    }

    public FailedFuture(ContextInternal context, String failureMessage) {
        this(context, new NoStackTraceThrowable(failureMessage));
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        if (handler instanceof Listener) {
            this.emitFailure(this.cause, (Listener)((Object)handler));
        } else if (this.context != null) {
            this.context.emit(this, handler);
        } else {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public Future<T> onSuccess(Handler<T> handler) {
        return this;
    }

    @Override
    public Future<T> onFailure(Handler<Throwable> handler) {
        if (this.context != null) {
            this.context.emit(this.cause, handler);
        } else {
            handler.handle(this.cause);
        }
        return this;
    }

    @Override
    public void addListener(Listener<T> listener) {
        this.emitFailure(this.cause, listener);
    }

    @Override
    public T result() {
        return null;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public boolean succeeded() {
        return false;
    }

    @Override
    public boolean failed() {
        return true;
    }

    @Override
    public <U> Future<U> map(Function<T, U> mapper) {
        return this;
    }

    @Override
    public <V> Future<V> map(V value) {
        return this;
    }

    @Override
    public Future<T> otherwise(T value) {
        return new SucceededFuture<T>(this.context, value);
    }

    public String toString() {
        return "Future{cause=" + this.cause.getMessage() + "}";
    }
}

