/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.util.internal.ObjectUtil;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrafficShapingOptionsConverter;
import java.util.concurrent.TimeUnit;

@DataObject(generateConverter=true, publicConverter=false)
public class TrafficShapingOptions {
    public static final long DEFAULT_INBOUND_GLOBAL_BANDWIDTH_LIMIT = 0L;
    public static final long DEFAULT_OUTBOUND_GLOBAL_BANDWIDTH_LIMIT = 0L;
    private long inboundGlobalBandwidth;
    private long outboundGlobalBandwidth;
    private long peakOutboundGlobalBandwidth;
    private long maxDelayToWait;
    private TimeUnit maxDelayToWaitTimeUnit;
    private long checkIntervalForStats;
    private TimeUnit checkIntervalForStatsTimeUnit;

    public TrafficShapingOptions() {
    }

    public TrafficShapingOptions(TrafficShapingOptions other) {
        this.inboundGlobalBandwidth = other.getInboundGlobalBandwidth();
        this.outboundGlobalBandwidth = other.getOutboundGlobalBandwidth();
        this.peakOutboundGlobalBandwidth = other.getPeakOutboundGlobalBandwidth();
        this.maxDelayToWait = other.getMaxDelayToWait();
        this.checkIntervalForStats = other.getCheckIntervalForStats();
    }

    public TrafficShapingOptions(JsonObject json) {
        TrafficShapingOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        TrafficShapingOptionsConverter.toJson(this, json);
        return json;
    }

    public TrafficShapingOptions setInboundGlobalBandwidth(long inboundGlobalBandwidth) {
        this.inboundGlobalBandwidth = inboundGlobalBandwidth;
        return this;
    }

    public TrafficShapingOptions setOutboundGlobalBandwidth(long outboundGlobalBandwidth) {
        this.outboundGlobalBandwidth = outboundGlobalBandwidth;
        return this;
    }

    public TrafficShapingOptions setMaxDelayToWait(long maxDelayToWaitTime) {
        this.maxDelayToWait = maxDelayToWaitTime;
        ObjectUtil.checkPositive((long)this.maxDelayToWait, (String)"maxDelayToWaitTime");
        return this;
    }

    public TrafficShapingOptions setMaxDelayToWaitUnit(TimeUnit maxDelayToWaitTimeUnit) {
        this.maxDelayToWaitTimeUnit = maxDelayToWaitTimeUnit;
        return this;
    }

    public TrafficShapingOptions setCheckIntervalForStats(long checkIntervalForStats) {
        this.checkIntervalForStats = checkIntervalForStats;
        ObjectUtil.checkPositive((long)this.checkIntervalForStats, (String)"checkIntervalForStats");
        return this;
    }

    public TrafficShapingOptions setCheckIntervalForStatsTimeUnit(TimeUnit checkIntervalForStatsTimeUnit) {
        this.maxDelayToWaitTimeUnit = this.maxDelayToWaitTimeUnit;
        return this;
    }

    public TrafficShapingOptions setPeakOutboundGlobalBandwidth(long peakOutboundGlobalBandwidth) {
        this.peakOutboundGlobalBandwidth = peakOutboundGlobalBandwidth;
        ObjectUtil.checkPositive((long)this.peakOutboundGlobalBandwidth, (String)"peakOutboundGlobalBandwidth");
        return this;
    }

    public long getInboundGlobalBandwidth() {
        return this.inboundGlobalBandwidth;
    }

    public long getOutboundGlobalBandwidth() {
        return this.outboundGlobalBandwidth;
    }

    public long getPeakOutboundGlobalBandwidth() {
        return this.peakOutboundGlobalBandwidth;
    }

    public long getMaxDelayToWait() {
        return this.maxDelayToWait;
    }

    public TimeUnit getMaxDelayToWaitTimeUnit() {
        return this.maxDelayToWaitTimeUnit;
    }

    public long getCheckIntervalForStats() {
        return this.checkIntervalForStats;
    }

    public TimeUnit getCheckIntervalForStatsTimeUnit() {
        return this.checkIntervalForStatsTimeUnit;
    }
}

