/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.RedisStandaloneConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisClient;
import io.vertx.redis.client.impl.RedisClusterClient;
import io.vertx.redis.client.impl.RedisReplicationClient;
import io.vertx.redis.client.impl.RedisSentinelClient;
import java.util.List;

@VertxGen
public interface Redis {
    public static Redis createClient(Vertx vertx) {
        return Redis.createClient(vertx, new RedisOptions());
    }

    public static Redis createClient(Vertx vertx, String connectionString) {
        return Redis.createClient(vertx, new RedisOptions().setConnectionString(connectionString));
    }

    public static Redis createClient(Vertx vertx, RedisOptions options) {
        switch (options.getType()) {
            case STANDALONE: {
                return new RedisClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), new RedisStandaloneConnectOptions(options), options.getTracingPolicy());
            }
            case SENTINEL: {
                return new RedisSentinelClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), new RedisSentinelConnectOptions(options), options.getTracingPolicy());
            }
            case CLUSTER: {
                return new RedisClusterClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), new RedisClusterConnectOptions(options), options.getTracingPolicy());
            }
            case REPLICATION: {
                return new RedisReplicationClient(vertx, options.getNetClientOptions(), options.getPoolOptions(), new RedisClusterConnectOptions(options), options.getTracingPolicy());
            }
        }
        throw new IllegalStateException("Unknown Redis Client type: " + (Object)((Object)options.getType()));
    }

    @Fluent
    default public Redis connect(Handler<AsyncResult<RedisConnection>> handler) {
        this.connect().onComplete(handler);
        return this;
    }

    public Future<RedisConnection> connect();

    public void close();

    @Fluent
    default public Redis send(Request command, Handler<AsyncResult<@Nullable Response>> onSend) {
        this.send(command).onComplete(onSend);
        return this;
    }

    public Future<@Nullable Response> send(Request var1);

    @Fluent
    default public Redis batch(List<Request> commands, Handler<AsyncResult<List<@Nullable Response>>> onSend) {
        this.batch(commands).onComplete(onSend);
        return this;
    }

    public Future<List<@Nullable Response>> batch(List<Request> var1);
}

