/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.TemplateLoader;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.JadeTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;

public class JadeTemplateEngineImpl
extends CachingTemplateEngine<JadeTemplate>
implements JadeTemplateEngine {
    private final JadeConfiguration config = new JadeConfiguration();
    private final JadeTemplateLoader loader = new JadeTemplateLoader();

    public JadeTemplateEngineImpl() {
        super("jade", 10000);
        this.config.setTemplateLoader(this.loader);
        this.config.setCaching(false);
    }

    @Override
    public JadeTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public JadeTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RoutingContext context, String templateDirectory, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            JadeTemplate template;
            templateFileName = templateDirectory + templateFileName;
            JadeTemplate jadeTemplate = template = this.isCachingEnabled() ? (JadeTemplate)this.cache.get((Object)templateFileName) : null;
            if (template == null) {
                JadeTemplateEngineImpl jadeTemplateEngineImpl = this;
                synchronized (jadeTemplateEngineImpl) {
                    this.loader.setVertx(context.vertx());
                    template = this.config.getTemplate(templateFileName);
                }
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFileName, (Object)template);
                }
            }
            HashMap<String, Object> variables = new HashMap<String, Object>(1);
            variables.put("context", context);
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)this.config.renderTemplate(template, variables))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    @Override
    public JadeConfiguration getJadeConfiguration() {
        return this.config;
    }

    private class JadeTemplateLoader
    implements TemplateLoader {
        private Vertx vertx;
        private long lastMod = System.currentTimeMillis();

        private JadeTemplateLoader() {
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        @Override
        public long getLastModified(String name) throws IOException {
            return this.lastMod;
        }

        @Override
        public Reader getReader(String name) throws IOException {
            String templ = Utils.readFileToString((Vertx)this.vertx, (String)(name = JadeTemplateEngineImpl.this.adjustLocation(name.endsWith(".jade") ? name.substring(0, name.length() - 5) : name)));
            if (templ == null) {
                throw new IllegalArgumentException("Cannot find resource " + name);
            }
            return new StringReader(templ);
        }
    }
}

