/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl2.internal.introspection.MethodKey;
import org.apache.commons.jexl2.internal.introspection.MethodMap;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassMap {
    private final MethodCache methodCache;
    private final Map<String, Field> fieldCache;

    ClassMap(Class<?> aClass, Log log) {
        this.methodCache = ClassMap.createMethodCache(aClass, log);
        this.fieldCache = ClassMap.createFieldCache(aClass);
    }

    Field findField(Class<?> clazz, String fname) {
        return this.fieldCache.get(fname);
    }

    String[] getFieldNames() {
        return this.fieldCache.keySet().toArray(new String[this.fieldCache.size()]);
    }

    private static Map<String, Field> createFieldCache(Class<?> clazz) {
        Field[] fields = clazz.getFields();
        if (fields.length > 0) {
            HashMap<String, Field> cache = new HashMap<String, Field>();
            for (Field field : fields) {
                cache.put(field.getName(), field);
            }
            return cache;
        }
        return Collections.emptyMap();
    }

    String[] getMethodNames() {
        return this.methodCache.names();
    }

    Method[] get(String methodName) {
        return this.methodCache.get(methodName);
    }

    Method findMethod(MethodKey key) throws MethodKey.AmbiguousException {
        return this.methodCache.get(key);
    }

    private static MethodCache createMethodCache(Class<?> classToReflect, Log log) {
        MethodCache cache = new MethodCache();
        while (classToReflect != null) {
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                ClassMap.populateMethodCacheWith(cache, classToReflect, log);
            }
            Class<?>[] interfaces = classToReflect.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ClassMap.populateMethodCacheWithInterface(cache, interfaces[i], log);
            }
            classToReflect = classToReflect.getSuperclass();
        }
        return cache;
    }

    private static void populateMethodCacheWithInterface(MethodCache cache, Class<?> iface, Log log) {
        if (Modifier.isPublic(iface.getModifiers())) {
            ClassMap.populateMethodCacheWith(cache, iface, log);
        }
        Class<?>[] supers = iface.getInterfaces();
        for (int i = 0; i < supers.length; ++i) {
            ClassMap.populateMethodCacheWithInterface(cache, supers[i], log);
        }
    }

    private static void populateMethodCacheWith(MethodCache cache, Class<?> clazz, Log log) {
        block3: {
            try {
                Method[] methods = clazz.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    int modifiers = methods[i].getModifiers();
                    if (!Modifier.isPublic(modifiers)) continue;
                    cache.put(methods[i]);
                }
            }
            catch (SecurityException se) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("While accessing methods of " + clazz + ": ", se);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MethodCache {
        private static final Method CACHE_MISS = MethodCache.cacheMiss();
        private static final int PRIMITIVE_SIZE = 13;
        private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES = new HashMap(13);
        private final Map<MethodKey, Method> methods = new HashMap<MethodKey, Method>();
        private final MethodMap methodMap = new MethodMap();

        MethodCache() {
        }

        public static Method cacheMiss() {
            try {
                return MethodCache.class.getMethod("cacheMiss", new Class[0]);
            }
            catch (Exception xio) {
                return null;
            }
        }

        static Class<?> primitiveClass(Class<?> parm) {
            Class<?> prim = PRIMITIVE_TYPES.get(parm);
            return prim == null ? parm : prim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Method get(MethodKey methodKey) throws MethodKey.AmbiguousException {
            MethodMap methodMap = this.methodMap;
            synchronized (methodMap) {
                Method cacheEntry = this.methods.get(methodKey);
                if (cacheEntry == CACHE_MISS) {
                    return null;
                }
                if (cacheEntry == null) {
                    try {
                        cacheEntry = this.methodMap.find(methodKey);
                        if (cacheEntry != null) {
                            this.methods.put(methodKey, cacheEntry);
                        } else {
                            this.methods.put(methodKey, CACHE_MISS);
                        }
                    }
                    catch (MethodKey.AmbiguousException ae) {
                        this.methods.put(methodKey, CACHE_MISS);
                        throw ae;
                    }
                }
                return cacheEntry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(Method method) {
            MethodMap methodMap = this.methodMap;
            synchronized (methodMap) {
                MethodKey methodKey = new MethodKey(method);
                if (this.methods.get(methodKey) == null) {
                    this.methods.put(methodKey, method);
                    this.methodMap.add(method);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] names() {
            MethodMap methodMap = this.methodMap;
            synchronized (methodMap) {
                return this.methodMap.names();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Method[] get(String methodName) {
            MethodMap methodMap = this.methodMap;
            synchronized (methodMap) {
                List<Method> lm = this.methodMap.get(methodName);
                if (lm != null && !lm.isEmpty()) {
                    return lm.toArray(new Method[lm.size()]);
                }
                return null;
            }
        }

        static {
            PRIMITIVE_TYPES.put(Boolean.TYPE, Boolean.class);
            PRIMITIVE_TYPES.put(Byte.TYPE, Byte.class);
            PRIMITIVE_TYPES.put(Character.TYPE, Character.class);
            PRIMITIVE_TYPES.put(Double.TYPE, Double.class);
            PRIMITIVE_TYPES.put(Float.TYPE, Float.class);
            PRIMITIVE_TYPES.put(Integer.TYPE, Integer.class);
            PRIMITIVE_TYPES.put(Long.TYPE, Long.class);
            PRIMITIVE_TYPES.put(Short.TYPE, Short.class);
        }
    }
}

