/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2LongMap;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2LongSortedMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.Double2LongMap;
import it.unimi.dsi.fastutil.doubles.Double2LongSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Double2LongLinkedOpenHashMap
extends AbstractDouble2LongSortedMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient long[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Double2LongSortedMap.FastSortedEntrySet entries;
    protected volatile transient DoubleSortedSet keys;
    protected volatile transient LongCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;

    public Double2LongLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.value = new long[this.n];
        this.used = new boolean[this.n];
        this.link = new long[this.n];
    }

    public Double2LongLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2LongLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2LongLinkedOpenHashMap(Map<? extends Double, ? extends Long> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2LongLinkedOpenHashMap(Map<? extends Double, ? extends Long> m) {
        this(m, 0.75f);
    }

    public Double2LongLinkedOpenHashMap(Double2LongMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2LongLinkedOpenHashMap(Double2LongMap m) {
        this(m, 0.75f);
    }

    public Double2LongLinkedOpenHashMap(double[] k, long[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2LongLinkedOpenHashMap(double[] k, long[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public long put(double k, long v) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                long oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Long put(Double ok, Long ov) {
        long v = ov;
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Long oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public long add(double k, long incr) {
        return this.addTo(k, incr);
    }

    public long addTo(double k, long incr) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                long oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos]) ^ (long)this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public long remove(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                this.fixPointers(pos);
                long v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Long remove(Object ok) {
        double k = (Double)ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                this.fixPointers(pos);
                long v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public long removeFirstLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.first;
        this.first = (int)this.link[pos];
        if (0 <= this.first) {
            int n = this.first;
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        }
        long v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public long removeLastLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.last;
        this.last = (int)(this.link[pos] >>> 32);
        if (0 <= this.last) {
            int n = this.last;
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        }
        long v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    private void moveIndexToFirst(int i) {
        if (this.size == 1 || this.first == i) {
            return;
        }
        if (this.last == i) {
            int n = this.last = (int)(this.link[i] >>> 32);
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.first;
        this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)i & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i;
    }

    private void moveIndexToLast(int i) {
        if (this.size == 1 || this.last == i) {
            return;
        }
        if (this.first == i) {
            int n = this.first = (int)this.link[i];
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.last;
        this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)i & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i;
    }

    public long getAndMoveToFirst(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                this.moveIndexToFirst(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public long getAndMoveToLast(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                this.moveIndexToLast(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public long putAndMoveToFirst(double k, long v) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                long oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToFirst(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.first;
            this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public long putAndMoveToLast(double k, long v) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                long oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToLast(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public Long get(Double ok) {
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public long get(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(long v) {
        long[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public double firstDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public Double2LongSortedMap tailMap(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2LongSortedMap headMap(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2LongSortedMap subMap(double from, double to) {
        throw new UnsupportedOperationException();
    }

    public Double2LongSortedMap.FastSortedEntrySet double2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                @Override
                public LongIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Double2LongLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(long v) {
                    return Double2LongLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Double2LongLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        double[] key = this.key;
        long[] value = this.value;
        int mask = newN - 1;
        double[] newKey = new double[newN];
        long[] newValue = new long[newN];
        boolean[] newUsed = new boolean[newN];
        long[] link = this.link;
        long[] newLink = new long[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLink[n2] = newLink[n2] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
    }

    public Double2LongLinkedOpenHashMap clone() {
        Double2LongLinkedOpenHashMap c;
        try {
            c = (Double2LongLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        long[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.value = new long[this.n];
        long[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new long[this.n];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            long v = s.readLong();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                link[n2] = link[n2] ^ (link[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            int n = pos;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements LongListIterator {
        @Override
        public long previousLong() {
            return Double2LongLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Long previous() {
            return Double2LongLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Long ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Long ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long nextLong() {
            return Double2LongLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Long next() {
            return Double2LongLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractDoubleSortedSet {
        private KeySet() {
        }

        @Override
        public DoubleListIterator iterator(double from) {
            return new KeyIterator(from);
        }

        @Override
        public DoubleListIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Double2LongLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(double k) {
            return Double2LongLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(double k) {
            int oldSize = Double2LongLinkedOpenHashMap.this.size;
            Double2LongLinkedOpenHashMap.this.remove(k);
            return Double2LongLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Double2LongLinkedOpenHashMap.this.clear();
        }

        @Override
        public double firstDouble() {
            if (Double2LongLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2LongLinkedOpenHashMap.this.key[Double2LongLinkedOpenHashMap.this.first];
        }

        @Override
        public double lastDouble() {
            if (Double2LongLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2LongLinkedOpenHashMap.this.key[Double2LongLinkedOpenHashMap.this.last];
        }

        @Override
        public DoubleComparator comparator() {
            return null;
        }

        @Override
        public final DoubleSortedSet tailSet(double from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet headSet(double to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet subSet(double from, double to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleListIterator {
        public KeyIterator(double k) {
            super(k);
        }

        @Override
        public double previousDouble() {
            return Double2LongLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double previous() {
            return Double2LongLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public double nextDouble() {
            return Double2LongLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Double2LongLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Double2LongMap.Entry>
    implements Double2LongSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Double2LongMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Double2LongMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Double2LongMap.Entry> subSet(Double2LongMap.Entry fromElement, Double2LongMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2LongMap.Entry> headSet(Double2LongMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2LongMap.Entry> tailSet(Double2LongMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double2LongMap.Entry first() {
            if (Double2LongLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2LongLinkedOpenHashMap.this.first);
        }

        @Override
        public Double2LongMap.Entry last() {
            if (Double2LongLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2LongLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)Double2LongLinkedOpenHashMap.this.mask) & Double2LongLinkedOpenHashMap.this.mask;
            while (Double2LongLinkedOpenHashMap.this.used[pos]) {
                if (Double2LongLinkedOpenHashMap.this.key[pos] == k) {
                    return Double2LongLinkedOpenHashMap.this.value[pos] == (Long)e.getValue();
                }
                pos = pos + 1 & Double2LongLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)Double2LongLinkedOpenHashMap.this.mask) & Double2LongLinkedOpenHashMap.this.mask;
            while (Double2LongLinkedOpenHashMap.this.used[pos]) {
                if (Double2LongLinkedOpenHashMap.this.key[pos] == k) {
                    Double2LongLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Double2LongLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Double2LongLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2LongLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Double2LongMap.Entry> iterator(Double2LongMap.Entry from) {
            return new EntryIterator((Double)from.getKey());
        }

        public ObjectBidirectionalIterator<Double2LongMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Double2LongMap.Entry> fastIterator(Double2LongMap.Entry from) {
            return new FastEntryIterator((Double)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2LongMap.Entry> {
        final AbstractDouble2LongMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractDouble2LongMap.BasicEntry(0.0, 0L);
        }

        public FastEntryIterator(double from) {
            super(from);
            this.entry = new AbstractDouble2LongMap.BasicEntry(0.0, 0L);
        }

        @Override
        public AbstractDouble2LongMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2LongLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2LongLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractDouble2LongMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Double2LongLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2LongLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Double2LongMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2LongMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2LongMap.Entry> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(double from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        @Override
        public void set(Double2LongMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2LongMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        private MapIterator() {
            this.next = Double2LongLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(double from) {
            if (Double2LongLinkedOpenHashMap.this.key[Double2LongLinkedOpenHashMap.this.last] != from) {
                int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(from) ^ (long)Double2LongLinkedOpenHashMap.this.mask) & Double2LongLinkedOpenHashMap.this.mask;
                while (Double2LongLinkedOpenHashMap.this.used[pos]) {
                    if (Double2LongLinkedOpenHashMap.this.key[pos] == from) {
                        this.next = (int)Double2LongLinkedOpenHashMap.this.link[pos];
                        this.prev = pos;
                        return;
                    }
                    pos = pos + 1 & Double2LongLinkedOpenHashMap.this.mask;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            this.prev = Double2LongLinkedOpenHashMap.this.last;
            this.index = Double2LongLinkedOpenHashMap.this.size;
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Double2LongLinkedOpenHashMap.this.size;
                return;
            }
            int pos = Double2LongLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)Double2LongLinkedOpenHashMap.this.link[pos];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Double2LongLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = (int)Double2LongLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = (int)(Double2LongLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Double2LongLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Double2LongLinkedOpenHashMap.this.link[this.curr];
            }
            --Double2LongLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Double2LongLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Double2LongLinkedOpenHashMap.this.link[n] = Double2LongLinkedOpenHashMap.this.link[n] ^ (Double2LongLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Double2LongLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Double2LongLinkedOpenHashMap.this.link[n] = Double2LongLinkedOpenHashMap.this.link[n] ^ (Double2LongLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Double2LongLinkedOpenHashMap.this.mask;
                while (Double2LongLinkedOpenHashMap.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(Double2LongLinkedOpenHashMap.this.key[pos]) ^ (long)Double2LongLinkedOpenHashMap.this.mask) & Double2LongLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Double2LongLinkedOpenHashMap.this.mask;
                }
                if (!Double2LongLinkedOpenHashMap.this.used[pos]) break;
                Double2LongLinkedOpenHashMap.this.key[last] = Double2LongLinkedOpenHashMap.this.key[pos];
                Double2LongLinkedOpenHashMap.this.value[last] = Double2LongLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Double2LongLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Double2LongLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Double2LongMap.Entry,
    Map.Entry<Double, Long> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2LongLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2LongLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Long getValue() {
            return Double2LongLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public long getLongValue() {
            return Double2LongLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public long setValue(long v) {
            long oldValue = Double2LongLinkedOpenHashMap.this.value[this.index];
            Double2LongLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double2LongLinkedOpenHashMap.this.key[this.index] == (Double)e.getKey() && Double2LongLinkedOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2LongLinkedOpenHashMap.this.key[this.index]) ^ HashCommon.long2int(Double2LongLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Double2LongLinkedOpenHashMap.this.key[this.index] + "=>" + Double2LongLinkedOpenHashMap.this.value[this.index];
        }
    }
}

