/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.mabb.fontverter.cff.CffFontAdapter;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalMetricsTable
extends OpenTypeTable {
    private static final Logger log = LoggerFactory.getLogger(HorizontalMetricsTable.class);
    private int[] advanceWidths;
    private short[] leftSideBearings;
    private Short[] nonHorizontalLeftSideBearing;

    @Override
    public String getTableType() {
        return "hmtx";
    }

    @Override
    public void readData(byte[] data) throws IOException {
        FontDataInputStream reader = new FontDataInputStream(data);
        int numHMetrics = this.font.getHhea().numberOfHMetrics;
        this.advanceWidths = new int[numHMetrics];
        this.leftSideBearings = new short[numHMetrics];
        for (int i = 0; i < numHMetrics; ++i) {
            this.advanceWidths[i] = reader.readUnsignedShort();
            this.leftSideBearings[i] = reader.readShort();
        }
        LinkedList<Short> nonHorzBearings = new LinkedList<Short>();
        while (reader.available() >= 2) {
            nonHorzBearings.add(reader.readShort());
        }
        this.nonHorizontalLeftSideBearing = nonHorzBearings.toArray(new Short[nonHorzBearings.size()]);
    }

    @Override
    protected byte[] generateUnpaddedData() throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        for (int i = 0; i < this.advanceWidths.length; ++i) {
            writer.writeUnsignedShort(this.advanceWidths[i]);
            writer.writeShort(this.leftSideBearings[i]);
        }
        for (Short bearingOn : this.nonHorizontalLeftSideBearing) {
            writer.writeUnsignedShort(bearingOn.shortValue());
        }
        return writer.toByteArray();
    }

    public static HorizontalMetricsTable createDefaultTable(OpenTypeFont font) {
        HorizontalMetricsTable table = new HorizontalMetricsTable();
        table.font = font;
        table.nonHorizontalLeftSideBearing = new Short[0];
        table.leftSideBearings = new short[0];
        table.advanceWidths = new int[0];
        return table;
    }

    @Override
    void normalize() throws IOException {
        if (this.advanceWidths == null) {
            this.leftSideBearings = new short[]{0};
            this.advanceWidths = new int[]{1000};
        }
        if (this.font.isCffType()) {
            CffFontAdapter cff = this.font.getCffTable().getCffFont();
            List<CffFontAdapter.CffGlyph> glyphs = cff.getGlyphs();
            if (glyphs.get(0).getLeftSideBearing() != 0) {
                glyphs.add(0, cff.createGlyph());
            }
            this.advanceWidths = new int[glyphs.size()];
            this.leftSideBearings = new short[glyphs.size()];
            for (int i = 0; i < glyphs.size(); ++i) {
                CffFontAdapter.CffGlyph glyphOn = glyphs.get(i);
                this.advanceWidths[i] = glyphOn.getAdvanceWidth();
                this.leftSideBearings[i] = (short)glyphOn.getLeftSideBearing();
            }
        }
        if (this.font.getCmap() != null) {
            this.loadMetrics();
        }
    }

    private void loadMetrics() {
        if (this.isFromParsedFont) {
            return;
        }
        int lsbArrCount = this.font.getCmap().getGlyphCount() - this.advanceWidths.length;
        if (lsbArrCount > 0) {
            this.nonHorizontalLeftSideBearing = new Short[lsbArrCount];
            for (int i = 0; i < lsbArrCount; ++i) {
                this.nonHorizontalLeftSideBearing[i] = 1;
            }
        } else {
            this.nonHorizontalLeftSideBearing = new Short[0];
        }
    }

    public int[] getAdvanceWidths() {
        return this.advanceWidths;
    }

    public short[] getLeftSideBearings() {
        return this.leftSideBearings;
    }
}

