/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Fold {
    static final String FOLD_LIST_ATTRIBUTE = "org.bounce.text.FoldList";
    static final String FOLDS_UPDATED_ATTRIBUTE = "org.bounce.text.FoldsUpdated";
    private List<Fold> children = null;
    private int fixedStart = -1;
    private Element start;
    private Element end;
    private int range = -1;

    public Fold(Element start, Element end) {
        this.start = start;
        this.end = end;
        this.range = this.getEnd() - this.getStart();
        this.children = new ArrayList<Fold>();
    }

    public int getStart() {
        if (this.fixedStart == -1) {
            return this.getRealStart();
        }
        return this.fixedStart;
    }

    public int getEnd() {
        if (this.range == -1) {
            return this.getRealEnd();
        }
        return this.getStart() + this.range;
    }

    private int getRealStart() {
        this.fixedStart = this.start.getParentElement().getElementIndex(this.start.getStartOffset());
        return this.fixedStart;
    }

    private int getRealEnd() {
        return this.end.getParentElement().getElementIndex(this.end.getStartOffset());
    }

    public boolean contains(int index) {
        return index > this.getStart() && index < this.getEnd();
    }

    public void add(Fold fold) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).contains(fold.getStart())) continue;
            this.children.get(i).add(fold);
            return;
        }
        this.children.add(fold);
    }

    public void remove(int start, int end) {
        ArrayList<Fold> temp = new ArrayList<Fold>(this.children);
        for (int i = 0; i < temp.size(); ++i) {
            Fold f = (Fold)temp.get(i);
            if (!f.contains(start) && !f.contains(end)) continue;
            f.remove(start, end);
            this.children.remove(f);
            for (Fold child : f.getChildren()) {
                this.children.add(child);
            }
            f.shallowCleanup();
        }
    }

    public List<Fold> getChildren() {
        return this.children;
    }

    public void update() {
        ArrayList<Fold> folds = new ArrayList<Fold>(this.children);
        for (int i = 0; i < folds.size(); ++i) {
            Fold fold = (Fold)folds.get(i);
            if (fold.isValid()) continue;
            fold.update();
            this.children.remove(fold);
            List<Fold> fs = fold.getChildren();
            for (int j = 0; j < fs.size(); ++j) {
                this.children.add(fs.get(j));
            }
        }
    }

    public boolean isValid() {
        return this.range == this.getRealEnd() - this.getRealStart();
    }

    public void shallowCleanup() {
        this.children.clear();
        this.start = null;
        this.end = null;
    }

    public void cleanup() {
        for (int i = 0; i < this.children.size(); ++i) {
            Fold child = this.children.get(i);
            child.cleanup();
        }
        this.shallowCleanup();
    }
}

