/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.LzopCodec;
import com.hadoop.mapreduce.LzoIndexOutputFormat;
import com.hadoop.mapreduce.LzoSplitInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedLzoIndexer
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DistributedLzoIndexer.class);
    private final String LZO_EXTENSION = new LzopCodec().getDefaultExtension();
    private final PathFilter nonTemporaryFilter = new PathFilter(){

        public boolean accept(Path path) {
            return !path.toString().endsWith("/_temporary");
        }
    };

    private void walkPath(Path path, PathFilter pathFilter, List<Path> accumulator) {
        try {
            FileSystem fs = path.getFileSystem(this.getConf());
            FileStatus fileStatus = fs.getFileStatus(path);
            if (fileStatus.isDir()) {
                FileStatus[] children;
                for (FileStatus childStatus : children = fs.listStatus(path, pathFilter)) {
                    this.walkPath(childStatus.getPath(), pathFilter, accumulator);
                }
            } else if (path.toString().endsWith(this.LZO_EXTENSION)) {
                Path lzoIndexPath = path.suffix(".index");
                if (fs.exists(lzoIndexPath)) {
                    if (fs.getFileStatus(lzoIndexPath).getLen() > 0L) {
                        LOG.info((Object)("[SKIP] LZO index file already exists for " + path));
                        return;
                    }
                    LOG.info((Object)("Adding LZO file " + path + " to indexing list (index file exists but is zero length)"));
                    accumulator.add(path);
                } else {
                    LOG.info((Object)("Adding LZO file " + path + " to indexing list (no index currently exists)"));
                    accumulator.add(path);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error walking path: " + path), (Throwable)ioe);
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0 || args.length == 1 && "--help".equals(args[0])) {
            DistributedLzoIndexer.printUsage();
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        for (String strPath : args) {
            this.walkPath(new Path(strPath), this.nonTemporaryFilter, inputPaths);
        }
        if (inputPaths.isEmpty()) {
            System.err.println("No input paths found - perhaps all .lzo files have already been indexed.");
            return 0;
        }
        Configuration conf = new Configuration();
        Job job = new Job(conf);
        job.setJobName("Distributed Lzo Indexer " + Arrays.toString(args));
        job.setOutputKeyClass(Path.class);
        job.setOutputValueClass(LongWritable.class);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.setJarByClass(DistributedLzoIndexer.class);
        job.setInputFormatClass(LzoSplitInputFormat.class);
        job.setOutputFormatClass(LzoIndexOutputFormat.class);
        job.setNumReduceTasks(0);
        job.setMapperClass(Mapper.class);
        for (Path p : inputPaths) {
            FileInputFormat.addInputPath((Job)job, (Path)p);
        }
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new DistributedLzoIndexer(), (String[])args);
        System.exit(exitCode);
    }

    public static void printUsage() {
        System.err.println("Usage: hadoop jar /path/to/this/jar com.hadoop.compression.lzo.DistributedLzoIndexer <file.lzo | directory> [file2.lzo directory3 ...]");
    }
}

