/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.LzoIndex;
import com.hadoop.compression.lzo.LzopCodec;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LzoIndexer {
    private static final Log LOG = LogFactory.getLog(LzoIndexer.class);
    private final Configuration conf_;
    private final String LZO_EXTENSION = new LzopCodec().getDefaultExtension();
    private final String INDENT_STRING = "  ";
    private final DecimalFormat df_;

    public LzoIndexer(Configuration conf) {
        this.conf_ = conf;
        this.df_ = new DecimalFormat("#0.00");
    }

    public void index(Path lzoPath) throws IOException {
        this.indexInternal(lzoPath, 0);
    }

    private String getNesting(int nestingLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nestingLevel; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private void indexInternal(Path lzoPath, int nestingLevel) throws IOException {
        FileSystem fs = FileSystem.get((URI)URI.create(lzoPath.toString()), (Configuration)this.conf_);
        FileStatus fileStatus = fs.getFileStatus(lzoPath);
        if (fileStatus.isDir()) {
            FileStatus[] statuses;
            LOG.info((Object)(this.getNesting(nestingLevel) + "LZO Indexing directory " + lzoPath + "..."));
            for (FileStatus childStatus : statuses = fs.listStatus(lzoPath)) {
                this.indexInternal(childStatus.getPath(), nestingLevel + 1);
            }
        } else if (lzoPath.toString().endsWith(this.LZO_EXTENSION)) {
            Path lzoIndexPath = new Path(lzoPath.toString() + ".index");
            if (fs.exists(lzoIndexPath)) {
                LOG.info((Object)(this.getNesting(nestingLevel) + "[SKIP] LZO index file already exists for " + lzoPath + "\n"));
            } else {
                long startTime = System.currentTimeMillis();
                long fileSize = fileStatus.getLen();
                LOG.info((Object)(this.getNesting(nestingLevel) + "[INDEX] LZO Indexing file " + lzoPath + ", size " + this.df_.format((double)fileSize / 1.073741824E9) + " GB..."));
                if (this.indexSingleFile(fs, lzoPath)) {
                    long indexSize = fs.getFileStatus(lzoIndexPath).getLen();
                    double elapsed = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                    LOG.info((Object)(this.getNesting(nestingLevel) + "Completed LZO Indexing in " + this.df_.format(elapsed) + " seconds (" + this.df_.format((double)fileSize / (1048576.0 * elapsed)) + " MB/s).  Index size is " + this.df_.format((double)indexSize / 1024.0) + " KB.\n"));
                }
            }
        }
    }

    private boolean indexSingleFile(FileSystem fs, Path lzoPath) {
        try {
            LzoIndex.createIndex(fs, lzoPath);
            return true;
        }
        catch (IOException e) {
            LOG.error((Object)("Error indexing " + lzoPath), (Throwable)e);
            return false;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            LzoIndexer.printUsage();
            System.exit(1);
        }
        LzoIndexer lzoIndexer = new LzoIndexer(new Configuration());
        for (String arg : args) {
            try {
                lzoIndexer.index(new Path(arg));
            }
            catch (IOException e) {
                LOG.error((Object)("Error indexing " + arg), (Throwable)e);
            }
        }
    }

    public static void printUsage() {
        System.out.println("Usage: hadoop jar /path/to/this/jar com.hadoop.compression.lzo.LzoIndexer <file.lzo | directory> [file2.lzo directory3 ...]");
    }
}

