/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.adbc.core.AdbcInfoCode;
import org.apache.arrow.adbc.core.StandardSchemas;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InfoMetadataBuilder
implements AutoCloseable {
    private static final byte STRING_VALUE_TYPE_ID = 0;
    private static final byte BIGINT_VALUE_TYPE_ID = 2;
    private static final Map<Integer, AddInfo> SUPPORTED_CODES = new HashMap<Integer, AddInfo>();
    private final BufferAllocator allocator;
    private final Collection<Integer> requestedCodes;
    private final DatabaseMetaData dbmd;
    private VectorSchemaRoot root;
    final UInt4Vector infoCodes;
    final DenseUnionVector infoValues;
    final VarCharVector stringValues;
    final BigIntVector bigIntValues;

    InfoMetadataBuilder(BufferAllocator allocator, Connection connection, int @Nullable [] infoCodes) throws SQLException {
        this.allocator = allocator;
        this.requestedCodes = infoCodes == null ? new ArrayList<Integer>(SUPPORTED_CODES.keySet()) : (Collection)IntStream.of(infoCodes).boxed().collect(Collectors.toList());
        this.root = VectorSchemaRoot.create((Schema)StandardSchemas.GET_INFO_SCHEMA, (BufferAllocator)allocator);
        this.dbmd = connection.getMetaData();
        this.infoCodes = (UInt4Vector)this.root.getVector(0);
        this.infoValues = (DenseUnionVector)this.root.getVector(1);
        this.stringValues = this.infoValues.getVarCharVector((byte)0);
        this.bigIntValues = this.infoValues.getBigIntVector((byte)2);
    }

    void setBigIntValue(int index, long value) {
        this.infoValues.setValueCount(index + 1);
        this.infoValues.setTypeId(index, (byte)2);
        this.bigIntValues.setSafe(index, value);
        this.infoValues.getOffsetBuffer().setInt((long)index * 4L, this.bigIntValues.getValueCount());
        this.bigIntValues.setValueCount(this.bigIntValues.getValueCount() + 1);
    }

    void setStringValue(int index, String value) {
        this.infoValues.setValueCount(index + 1);
        this.infoValues.setTypeId(index, (byte)0);
        this.stringValues.setSafe(index, value.getBytes(StandardCharsets.UTF_8));
        this.infoValues.getOffsetBuffer().setInt((long)index * 4L, this.stringValues.getLastSet());
    }

    VectorSchemaRoot build() throws SQLException {
        int rowIndex = 0;
        for (Integer code : this.requestedCodes) {
            AddInfo metadata = SUPPORTED_CODES.get(code);
            if (metadata == null) continue;
            this.infoCodes.setSafe(rowIndex, code.intValue());
            metadata.accept(this, rowIndex++);
        }
        this.root.setRowCount(rowIndex);
        VectorSchemaRoot result = this.root;
        try {
            this.root = VectorSchemaRoot.create((Schema)StandardSchemas.GET_INFO_SCHEMA, (BufferAllocator)this.allocator);
        }
        catch (RuntimeException e) {
            result.close();
            throw e;
        }
        return result;
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.root});
    }

    static {
        SUPPORTED_CODES.put(AdbcInfoCode.VENDOR_NAME.getValue(), (b, idx) -> b.setStringValue(idx, b.dbmd.getDatabaseProductName()));
        SUPPORTED_CODES.put(AdbcInfoCode.VENDOR_VERSION.getValue(), (b, idx) -> b.setStringValue(idx, b.dbmd.getDatabaseProductVersion()));
        SUPPORTED_CODES.put(AdbcInfoCode.DRIVER_NAME.getValue(), (b, idx) -> {
            String driverName = "ADBC JDBC Driver (" + b.dbmd.getDriverName() + ")";
            b.setStringValue(idx, driverName);
        });
        SUPPORTED_CODES.put(AdbcInfoCode.DRIVER_VERSION.getValue(), (b, idx) -> {
            String driverVersion = b.dbmd.getDriverVersion() + " (ADBC Driver Version 0.0.1)";
            b.setStringValue(idx, driverVersion);
        });
        SUPPORTED_CODES.put(AdbcInfoCode.DRIVER_ADBC_VERSION.getValue(), (b, idx) -> b.setBigIntValue(idx, 1001000L));
    }

    @FunctionalInterface
    static interface AddInfo {
        public void accept(InfoMetadataBuilder var1, int var2) throws SQLException;
    }
}

