/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.driver.jdbc.JdbcDriverUtil;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcArrowReader
extends ArrowReader {
    private final ArrowVectorIterator delegate;
    private final Schema schema;
    private long bytesRead;

    JdbcArrowReader(BufferAllocator allocator, ResultSet resultSet, @Nullable Schema overrideSchema) throws AdbcException {
        super(allocator);
        JdbcToArrowConfig config = JdbcArrowReader.makeJdbcConfig(allocator);
        try {
            this.delegate = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)resultSet, (JdbcToArrowConfig)config);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        catch (IOException e) {
            throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage(e.getMessage()), (Throwable)e, AdbcStatusCode.IO, null, -1);
        }
        if (overrideSchema != null) {
            this.schema = overrideSchema;
        } else {
            try {
                this.schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSet.getMetaData(), (JdbcToArrowConfig)config);
            }
            catch (SQLException e) {
                throw JdbcDriverUtil.fromSqlException("Failed to convert JDBC schema to Arrow schema:", e, new Object[0]);
            }
        }
        this.bytesRead = 0L;
        try {
            this.ensureInitialized();
        }
        catch (IOException e) {
            throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage(e.getMessage()), (Throwable)e, AdbcStatusCode.IO, null, 0);
        }
    }

    static JdbcToArrowConfig makeJdbcConfig(BufferAllocator allocator) {
        return new JdbcToArrowConfigBuilder().setAllocator(allocator).setCalendar(JdbcToArrowUtils.getUtcCalendar()).setTargetBatchSize(1024).build();
    }

    public boolean loadNextBatch() {
        if (!this.delegate.hasNext()) {
            return false;
        }
        try (VectorSchemaRoot root = this.delegate.next();){
            VectorUnloader unloader = new VectorUnloader(root);
            try (ArrowRecordBatch recordBatch = unloader.getRecordBatch();){
                this.bytesRead += recordBatch.computeBodyLength();
                this.loadRecordBatch(recordBatch);
            }
        }
        return true;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    protected void closeReadSource() {
        this.delegate.close();
    }

    protected Schema readSchema() {
        return this.schema;
    }
}

