/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcParameterBinder;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JdbcBindReader
extends ArrowReader {
    private final PreparedStatement statement;
    private final JdbcParameterBinder binder;
    private @Nullable ResultSet currentResultSet;
    private @Nullable ArrowVectorIterator currentSource;

    JdbcBindReader(BufferAllocator allocator, PreparedStatement statement, VectorSchemaRoot bindParameters) {
        super(allocator);
        this.statement = statement;
        this.binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)bindParameters).bindAll().build();
    }

    public boolean loadNextBatch() throws IOException {
        if (!(this.currentSource != null && this.currentSource.hasNext() || this.advance())) {
            return false;
        }
        if (this.currentSource == null) {
            throw new IllegalStateException("Source was null after advancing reader");
        }
        try (VectorSchemaRoot root = this.currentSource.next();
             ArrowRecordBatch batch = new VectorUnloader(root).getRecordBatch();){
            this.loadRecordBatch(batch);
        }
        return true;
    }

    public long bytesRead() {
        return 0L;
    }

    protected void closeReadSource() throws IOException {
        if (this.currentResultSet != null) {
            try {
                this.currentResultSet.close();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    protected Schema readSchema() throws IOException {
        try {
            if (!this.advance()) {
                throw new IOException("Parameter set is empty!");
            }
            if (this.currentResultSet == null) {
                throw new IllegalStateException("Driver returned null result set");
            }
            return JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)this.currentResultSet.getMetaData(), (Calendar)JdbcToArrowUtils.getUtcCalendar());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private boolean advance() throws IOException {
        try {
            if (this.binder.next()) {
                if (this.currentSource != null) {
                    this.currentSource.close();
                }
                if (this.currentResultSet != null) {
                    this.currentResultSet.close();
                }
                this.currentResultSet = this.statement.executeQuery();
                this.currentSource = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.currentResultSet, (BufferAllocator)this.allocator);
                return true;
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return false;
    }
}

