/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatement;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.BulkIngestMode;
import org.apache.arrow.adbc.core.IsolationLevel;
import org.apache.arrow.adbc.core.StandardSchemas;
import org.apache.arrow.adbc.driver.jdbc.InfoMetadataBuilder;
import org.apache.arrow.adbc.driver.jdbc.JdbcArrowReader;
import org.apache.arrow.adbc.driver.jdbc.JdbcDriverUtil;
import org.apache.arrow.adbc.driver.jdbc.JdbcQuirks;
import org.apache.arrow.adbc.driver.jdbc.JdbcStatement;
import org.apache.arrow.adbc.driver.jdbc.ObjectMetadataBuilder;
import org.apache.arrow.adbc.driver.jdbc.RootArrowReader;
import org.apache.arrow.adbc.driver.jdbc.adapter.JdbcFieldInfoExtra;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcConnection
implements AdbcConnection {
    private final BufferAllocator allocator;
    private final Connection connection;
    private final JdbcQuirks quirks;

    JdbcConnection(BufferAllocator allocator, Connection connection, JdbcQuirks quirks) {
        this.allocator = allocator;
        this.connection = connection;
        this.quirks = quirks;
    }

    public void commit() throws AdbcException {
        try {
            this.checkAutoCommit();
            this.connection.commit();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public AdbcStatement createStatement() throws AdbcException {
        return new JdbcStatement(this.allocator, this.connection, this.quirks);
    }

    public AdbcStatement bulkIngest(String targetTableName, BulkIngestMode mode) throws AdbcException {
        return JdbcStatement.ingestRoot(this.allocator, this.connection, this.quirks, targetTableName, mode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrowReader getInfo(int @Nullable [] infoCodes) throws AdbcException {
        try (VectorSchemaRoot root = new InfoMetadataBuilder(this.allocator, this.connection, infoCodes).build();){
            ArrowReader arrowReader = RootArrowReader.fromRoot(this.allocator, root);
            return arrowReader;
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrowReader getObjects(AdbcConnection.GetObjectsDepth depth, String catalogPattern, String dbSchemaPattern, String tableNamePattern, String[] tableTypes, String columnNamePattern) throws AdbcException {
        try (VectorSchemaRoot root = new ObjectMetadataBuilder(this.allocator, this.connection, depth, catalogPattern, dbSchemaPattern, tableNamePattern, tableTypes, columnNamePattern).build();){
            ArrowReader arrowReader = RootArrowReader.fromRoot(this.allocator, root);
            return arrowReader;
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public ArrowReader getStatistics(String catalogPattern, String dbSchemaPattern, String tableNamePattern, boolean approximate) throws AdbcException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArrowReader getStatisticNames() throws AdbcException {
        return super.getStatisticNames();
    }

    public Schema getTableSchema(String catalog, String dbSchema, String tableName) throws AdbcException {
        try (ResultSet rs = this.connection.getMetaData().getTables(catalog, dbSchema, tableName, null);){
            if (!rs.next()) {
                throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("Table not found: " + tableName), null, AdbcStatusCode.NOT_FOUND, null, 0);
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        try (ResultSet rs = this.connection.getMetaData().getColumns(catalog, dbSchema, tableName, null);){
            while (rs.next()) {
                @Nullable String fieldName = rs.getString("COLUMN_NAME");
                if (fieldName == null) {
                    fieldName = "";
                }
                JdbcFieldInfoExtra fieldInfoExtra = new JdbcFieldInfoExtra(rs);
                ArrowType arrowType = (ArrowType)this.quirks.getTypeConverter().apply(fieldInfoExtra);
                if (arrowType == null) {
                    throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage(String.format("Column '%s' has unsupported type: %s", fieldName, fieldInfoExtra)));
                }
                Field field = new Field(fieldName, fieldInfoExtra.isNullable() == 0 ? FieldType.notNullable((ArrowType)arrowType) : FieldType.nullable((ArrowType)arrowType), Collections.emptyList());
                fields.add(field);
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        return new Schema(fields);
    }

    public ArrowReader getTableTypes() throws AdbcException {
        try {
            return new JdbcArrowReader(this.allocator, this.connection.getMetaData().getTableTypes(), StandardSchemas.TABLE_TYPES_SCHEMA);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void rollback() throws AdbcException {
        try {
            this.checkAutoCommit();
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public boolean getAutoCommit() throws AdbcException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setAutoCommit(boolean enableAutoCommit) throws AdbcException {
        try {
            this.connection.setAutoCommit(enableAutoCommit);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public String getCurrentCatalog() throws AdbcException {
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setCurrentCatalog(String catalog) throws AdbcException {
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public String getCurrentDbSchema() throws AdbcException {
        try {
            return this.connection.getSchema();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setCurrentDbSchema(String dbSchema) throws AdbcException {
        try {
            this.connection.setSchema(dbSchema);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public boolean getReadOnly() throws AdbcException {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setReadOnly(boolean isReadOnly) throws AdbcException {
        try {
            this.connection.setReadOnly(isReadOnly);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public IsolationLevel getIsolationLevel() throws AdbcException {
        try {
            int transactionIsolation = this.connection.getTransactionIsolation();
            switch (transactionIsolation) {
                case 0: {
                    return IsolationLevel.DEFAULT;
                }
                case 1: {
                    return IsolationLevel.READ_UNCOMMITTED;
                }
                case 2: {
                    return IsolationLevel.READ_COMMITTED;
                }
                case 4: {
                    return IsolationLevel.REPEATABLE_READ;
                }
                case 8: {
                    return IsolationLevel.SERIALIZABLE;
                }
            }
            throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage("JDBC isolation level not recognized: " + transactionIsolation));
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setIsolationLevel(IsolationLevel level) throws AdbcException {
        try {
            switch (level) {
                case READ_UNCOMMITTED: {
                    this.connection.setTransactionIsolation(1);
                    break;
                }
                case READ_COMMITTED: {
                    this.connection.setTransactionIsolation(2);
                    break;
                }
                case REPEATABLE_READ: {
                    this.connection.setTransactionIsolation(4);
                    break;
                }
                case SERIALIZABLE: {
                    this.connection.setTransactionIsolation(8);
                    break;
                }
                case DEFAULT: 
                case SNAPSHOT: 
                case LINEARIZABLE: {
                    throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage("Isolation level not supported: " + level));
                }
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.connection, this.allocator});
    }

    private void checkAutoCommit() throws AdbcException, SQLException {
        if (this.connection.getAutoCommit()) {
            throw AdbcException.invalidState((String)"[JDBC] Cannot perform operation in autocommit mode");
        }
    }

    public String toString() {
        return "JdbcConnection{connection=" + this.connection + '}';
    }

    static final class Statistic {
        String table;
        String column;
        short key;
        long value;
        boolean multiColumn = false;

        public Statistic(String table, String column) {
            this.table = table;
            this.column = column;
        }
    }
}

