/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcDatabase;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.driver.jdbc.JdbcConnection;
import org.apache.arrow.adbc.driver.jdbc.JdbcDriverUtil;
import org.apache.arrow.adbc.driver.jdbc.JdbcQuirks;
import org.apache.arrow.memory.BufferAllocator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JdbcDataSourceDatabase
implements AdbcDatabase {
    private final BufferAllocator allocator;
    private final DataSource dataSource;
    private final @Nullable String username;
    private final @Nullable String password;
    private final JdbcQuirks quirks;
    private final AtomicInteger counter;
    private @Nullable Connection connection;

    JdbcDataSourceDatabase(BufferAllocator allocator, DataSource dataSource, @Nullable String username, @Nullable String password, JdbcQuirks quirks) throws AdbcException {
        this.allocator = Objects.requireNonNull(allocator);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.username = username;
        this.password = password;
        this.quirks = Objects.requireNonNull(quirks);
        this.connection = null;
        this.counter = new AtomicInteger();
    }

    public AdbcConnection connect() throws AdbcException {
        @Nullable Connection conn = this.connection;
        try {
            if (conn == null) {
                conn = this.username != null && this.password != null ? (this.connection = this.dataSource.getConnection(this.username, this.password)) : (this.connection = this.dataSource.getConnection());
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        int count = this.counter.getAndIncrement();
        return new JdbcConnection(this.allocator.newChildAllocator("adbc-jdbc-datasource-connection-" + count, 0L, this.allocator.getLimit()), conn, this.quirks);
    }

    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    public String toString() {
        return "JdbcDatabase{dataSource='" + this.dataSource + '\'' + '}';
    }
}

