/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JdbcDriverUtil {
    private static final Set<String> SQLSTATE_TABLE_NOT_FOUND = new HashSet<String>(Arrays.asList("42X05", "42S02", "42P01"));

    private JdbcDriverUtil() {
        throw new AssertionError((Object)"Do not instantiate this class");
    }

    static String prefixExceptionMessage(@Nullable String s) {
        if (s == null) {
            return "[JDBC] (No or unknown error)";
        }
        return "[JDBC] " + s;
    }

    static AdbcStatusCode guessStatusCode(@Nullable String sqlState) {
        if (sqlState == null) {
            return AdbcStatusCode.UNKNOWN;
        }
        if (SQLSTATE_TABLE_NOT_FOUND.contains(sqlState)) {
            return AdbcStatusCode.NOT_FOUND;
        }
        return AdbcStatusCode.UNKNOWN;
    }

    static AdbcException fromSqlException(SQLException e) {
        Throwable cause;
        if (JdbcDriverUtil.isUnknown(e) && (cause = e.getCause()) instanceof SQLException && !JdbcDriverUtil.isUnknown((SQLException)cause)) {
            return JdbcDriverUtil.fromSqlException((SQLException)cause);
        }
        String message = e.getMessage();
        if (JdbcDriverUtil.isJdbcSpecific(e)) {
            message = JdbcDriverUtil.prefixExceptionMessage(message);
        }
        return new AdbcException(message, e.getCause(), JdbcDriverUtil.guessStatusCode(e.getSQLState()), e.getSQLState(), e.getErrorCode());
    }

    static AdbcException fromSqlException(String format, SQLException e, Object ... values) {
        return JdbcDriverUtil.fromSqlException(JdbcDriverUtil.guessStatusCode(e.getSQLState()), format, e, values);
    }

    static AdbcException fromSqlException(AdbcStatusCode status, String format, SQLException e, Object ... values) {
        String message = "[JDBC] " + String.format(format, values) + e.getMessage();
        return new AdbcException(message, e.getCause(), status, e.getSQLState(), e.getErrorCode());
    }

    private static boolean isUnknown(SQLException e) {
        return e.getSQLState() == null && e.getErrorCode() == 0;
    }

    private static boolean isJdbcSpecific(SQLException e) {
        Throwable cause = e.getCause();
        return !(cause instanceof ConnectException);
    }
}

